-- $Id: sem-compunit-attributedesignatortypefromcontext.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)
function AttributeDesignatorTypeFromContext
  (ExpNode       : in     STree.SyntaxNode;
   IsAnnotation  : in     Boolean;
   EStack        : in     ExpStack.ExpStackType;
   TStack        : in     TypeContextStack.TStackType)
  return Dictionary.Symbol
is
   ATT_LOOKUP : constant Annotation_Symbol_Table :=
      Annotation_Symbol_Table'(False => SPSymbols.attribute_designator,
                               True  => SPSymbols.annotation_attribute_designator);

   IdentNode      : STree.SyntaxNode;
   ArgExpNode     : STree.SyntaxNode;
   NewContextType : Dictionary.Symbol;
   TopOfExpStack  : ExpRecord;
   IdentStr       : LexTokenManager.LexString;
begin
   -- Assume NodeType(ExpNode) = attribute_designator
   --        NodeType(ExpNode) = annotation_attribute_designator

   TopOfExpStack := ExpStack.Top (EStack);

   -- Find the attribute identifier (e.g. "Val" or "Max")
   IdentNode := Child_Node (ExpNode);
   if SyntaxNodeType (IdentNode) = ATT_LOOKUP (IsAnnotation) then
      IdentNode := Next_Sibling (IdentNode);
   end if;
   IdentStr := NodeLexString (IdentNode);

   -- Find the (possibly non-existant) first argument.
   ArgExpNode := Child_Node (Next_Sibling (IdentNode));

   if ArgExpNode = STree.NullNode then
      -- No arguments for this attribute, so no change in context
      NewContextType := TypeContextStack.Top (TStack);
   else
      -- This attribute has 1 or 2 arguments.  The context for them
      -- is always the same (phew!), but depends on the prefix

      if (IdentStr = LexTokenManager.ValToken or
          IdentStr = LexTokenManager.FirstToken or
          IdentStr = LexTokenManager.LastToken or
          IdentStr = LexTokenManager.LengthToken or
          IdentStr = LexTokenManager.RangeToken) then

         -- 'Val takes any integer, modular, or universal integer as argument
         -- in SPARK95, or universal integer only in SPARK83.
         -- Array attributes (when they have an argument) likewise.
         -- There is no context available.
         NewContextType := Dictionary.GetUniversalIntegerType;

      elsif (IdentStr = LexTokenManager.TailToken or
             IdentStr = LexTokenManager.AppendToken) then

         -- Tail and Append never change context
         NewContextType := TypeContextStack.Top (TStack);

      elsif (IdentStr = LexTokenManager.PosToken or
             IdentStr = LexTokenManager.PredToken or
             IdentStr = LexTokenManager.SuccToken or
             IdentStr = LexTokenManager.MinToken or
             IdentStr = LexTokenManager.MaxToken or
             IdentStr = LexTokenManager.FloorToken or
             IdentStr = LexTokenManager.CeilingToken) then

         -- Other attributes with arguments -
         -- context is the type given by the prefix.
         NewContextType := TopOfExpStack.TypeSymbol;

      else
         -- Any other attribute with an argument must be an error,
         -- which will be picked up later on in wf_attribute_designator, but
         -- we still have to push something, so...
         NewContextType := TypeContextStack.Top (TStack);
      end if;

   end if;

   return NewContextType;

end AttributeDesignatorTypeFromContext;
