-- $Id: sem-compunit-addderivesstreameffects.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Sem.CompUnit)
procedure AddDerivesStreamEffects (Node        : in STree.SyntaxNode;
                                   SubprogSym  : in Dictionary.Symbol;
                                   Abstraction : in Dictionary.Abstractions)
is
   ExportIt,
   ImportIt  : Dictionary.Iterator;
   ExportSym,
   ImportSym : Dictionary.Symbol;

--   procedure MakeDependentOnOtherImports (Abstraction : in Dictionary.Abstractions;
--                                          SubprogSym  : in Dictionary.Symbol;
--                                          ImportSym   : in Dictionary.Symbol;
--                                          Loc         : in Dictionary.Location)
--
--   --# global  SPARK_IO.FILE_SYS,
--   --#         Dictionary.Dict,
--   --#         LexTokenManager.StringTable;
--   --# derives
--   --#   Dictionary.Dict
--   --#   from
--   --#       Abstraction,
--   --#       Dictionary.Dict,
--   --#       SubprogSym,
--   --#       ImportSym
--   --#     &
--   --#   SPARK_IO.FILE_SYS
--   --#   from
--   --#       Abstraction,
--   --#       Dictionary.Dict,
--   --#       LexTokenManager.StringTable,
--   --#       SPARK_IO.FILE_SYS,
--   --#       SubprogSym,
--   --#       ImportSym,
--   --#       Loc;
--   is
--      It  : Dictionary.Iterator;
--      Sym : Dictionary.Symbol;
--
--   begin --MakeDependentOnOtherImports
--      It := Dictionary.FirstImport (Abstraction,
--                                    SubprogSym);
--      while not Dictionary.IsNullIterator (It) loop
--         Sym := Dictionary.CurrentSymbol (It);
--         if Dictionary.GetOwnVariableOrConstituentMode (ImportSym) /= Dictionary.OutMode then
--            Dictionary.AddDependency (Abstraction,
--                                      SubprogSym,
--                                      ImportSym,
--                                      Sym,
--                                      Loc);
--         end if;
--         It := Dictionary.NextSymbol (It);
--      end loop;
--   end MakeDependentOnOtherImports;

begin -- AddDerivesStreamEffects
   -- first scan exports for reference to out streams
   ExportIt := Dictionary.FirstExport (Abstraction,
                                       SubprogSym);
   while not Dictionary.IsNullIterator (ExportIt) loop
      ExportSym := Dictionary.CurrentSymbol (ExportIt);
      -- writes to an out streams are also implicit imports
      if Dictionary.GetOwnVariableOrConstituentMode (ExportSym) = Dictionary.OutMode then
         Dictionary.AddDependency (Abstraction,
                                   SubprogSym,
                                   ExportSym,
                                   ExportSym,
                                   Dictionary.Location'(NodePosition (Node),
                                                        NodePosition (Node)));
      end if;
      ExportIt := Dictionary.NextSymbol (ExportIt);
   end loop;

   -- now scan imports for reads of in streams
   ImportIt := Dictionary.FirstImport (Abstraction,
                                       SubprogSym);
   while not Dictionary.IsNullIterator (ImportIt) loop
      ImportSym := Dictionary.CurrentSymbol (ImportIt);
      -- reads of in streams imply an update as well
      if Dictionary.GetOwnVariableOrConstituentMode (ImportSym) = Dictionary.InMode then
         Dictionary.AddExport (Abstraction,
                               SubprogSym,
                               ImportSym,
                               Dictionary.Location'(NodePosition (Node),
                                                    NodePosition (Node)),
                               Dictionary.Location'(NodePosition (Node),
                                                    NodePosition (Node)));
         Dictionary.AddDependency (Abstraction,
                                   SubprogSym,
                                   ImportSym,
                                   ImportSym,
                                   Dictionary.Location'(NodePosition (Node),
                                                        NodePosition (Node)));
         -- also make implicit export dependent on all other (non-implicit imports)
         --MakeDependentOnOtherImports (Abstraction,
         --                             SubprogSym,
         --                             ImportSym,
         --                             Dictionary.Location'(NodePosition (Node),
         --                                                  NodePosition (Node)));
      end if;
      ImportIt := Dictionary.NextSymbol (ImportIt);
   end loop;
end AddDerivesStreamEffects;
