-- $Id: screenecho.adb 11889 2008-12-12 15:49:12Z rod chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


package body ScreenEcho
is

   procedure Put_Char (Item : in Character)
   is
   begin
      SPARK_IO.Put_Char (SPARK_IO.Standard_Output, Item);
   end Put_Char;

   ----------------------------------------------------------------------------

   procedure Put_Integer (Item  : in Integer;
                          Width : in Natural;
                          Base  : in SPARK_IO.Number_Base)
   is
   begin
      SPARK_IO.Put_Integer (SPARK_IO.Standard_Output, Item, Width, Base);
   end Put_Integer;

   ----------------------------------------------------------------------------

   procedure Put_String (Item : in String)
   is
   begin
      SPARK_IO.Put_String (SPARK_IO.Standard_Output, Item, 0);
   end Put_String;

   ----------------------------------------------------------------------------

   procedure Put_Line (Item : in String)
   is
   begin
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output, Item, 0);
   end Put_Line;

   ----------------------------------------------------------------------------

   procedure Put_StringWithLength (Item : in String; Stop : in Natural)
   is
   begin
      SPARK_IO.Put_String (SPARK_IO.Standard_Output, Item, Stop);
   end Put_StringWithLength;

   ----------------------------------------------------------------------------

   procedure Put_LineWithLength (Item : in String; Stop : in Natural)
   is
   begin
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output, Item, Stop);
   end Put_LineWithLength;

   ----------------------------------------------------------------------------

   procedure New_Line (Spacing : in Positive)
   is
   begin
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, Spacing);
   end New_Line;

   ----------------------------------------------------------------------------

   procedure Set_Col (Posn : in Positive)
   is
   begin
      SPARK_IO.Set_Col (SPARK_IO.Standard_Output, Posn);
   end Set_Col;

   ----------------------------------------------------------------------------

   procedure Put_ExaminerString (Item : in EStrings.T)
   is
   begin
      if Item.Length /= 0 then
         SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                              Item.Content,
                              Item.Length);
      end if;
   end Put_ExaminerString;

   ----------------------------------------------------------------------------

   procedure Put_ExaminerLine (Item : in EStrings.T)
   is
   begin
      if Item.Length = 0 then
         SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
      else
         SPARK_IO.Put_Line (SPARK_IO.Standard_Output, Item.Content, Item.Length);
      end if;
   end Put_ExaminerLine;

   ----------------------------------------------------------------------------

   procedure Echo (Str : in EStrings.T)
   is
      procedure PrintLine (StartPos,
                              EndPos,
                              Indent   : in Natural;
                           Line     : in EStrings.T)
      --# global in out SPARK_IO.FILE_SYS;
      --# derives SPARK_IO.FILE_SYS from *,
      --#                                EndPos,
      --#                                Indent,
      --#                                Line,
      --#                                StartPos;
      is
         Pos,
         CurrentLineEnd,
         CurrentLineStart : Natural;

         procedure PRINT_CURRENT_LINE
         --# global in     CurrentLineEnd;
         --#        in     CurrentLineStart;
         --#        in     Line;
         --#        in out SPARK_IO.FILE_SYS;
         --# derives SPARK_IO.FILE_SYS from *,
         --#                                CurrentLineEnd,
         --#                                CurrentLineStart,
         --#                                Line;
         is
         begin
            for Ix in Natural range CurrentLineStart .. CurrentLineEnd
            loop
               Put_Char (Line.Content (Ix));
            end loop;
         end PRINT_CURRENT_LINE;

         procedure FIND_CURRENT_LINE_END (CurrentLinePos : in Natural)
         --# global in     CurrentLineStart;
         --#        in     EndPos;
         --#        in     Line;
         --#        in     Pos;
         --#           out CurrentLineEnd;
         --# derives CurrentLineEnd from CurrentLinePos,
         --#                             CurrentLineStart,
         --#                             EndPos,
         --#                             Line,
         --#                             Pos;
         is
            NextSpacePos,
            CurrentSpacePos : Integer;

            function FindNextSpace (CurrPos : in Natural) return Natural
            --# global in Line;
            is
               NextPos : Natural;
            begin
               NextPos := CurrPos;
               loop
                  exit when NextPos = Line.Length;
                  NextPos := NextPos + 1;
                  exit when Line.Content (NextPos) = ' ';
               end loop;
               return NextPos;
            end FindNextSpace;

         begin
            CurrentSpacePos := FindNextSpace (CurrentLinePos);
            loop
               exit when CurrentSpacePos = Line.Length;
               NextSpacePos := FindNextSpace (CurrentSpacePos);
               exit when (Pos + NextSpacePos) - CurrentLineStart > EndPos;
               CurrentSpacePos := NextSpacePos;
            end loop;
            CurrentLineEnd := CurrentSpacePos;
         end FIND_CURRENT_LINE_END;

      begin
         CurrentLineStart := 1;
         Pos := StartPos;
         FIND_CURRENT_LINE_END (0);
         loop
            PRINT_CURRENT_LINE;
            exit when CurrentLineEnd = Line.Length;

            New_Line (1);
            Set_Col (Indent);
            Pos := Indent;
            CurrentLineStart := CurrentLineEnd + 1;
            FIND_CURRENT_LINE_END (CurrentLineStart);
         end loop;
      end PrintLine;

   begin
      New_Line (1);
      Set_Col (12);
      PrintLine (12, 80, 12, Str);
      Put_Line (" ...");
   end Echo;

end ScreenEcho;
