-- $Id: maths-valuetostring.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Maths)
function ValueToString (Num : Value) return ELStrings.T
is
   OutBuffer  : ELStrings.T;

   ---------------------------------------------------------

   procedure WriteChar (Ch : in     Character)
      --# global in out outBuffer;
      --# derives outBuffer from *,
      --#                        ch;
   is
   begin
      OutBuffer.Length := OutBuffer.Length + 1;
      OutBuffer.Content (OutBuffer.Length) := Ch;
   end WriteChar;

   ---------------------------------------------------------

   procedure DoSign
      --# global in     Num;
      --#        in out outBuffer;
      --# derives outBuffer from *,
      --#                        Num;
   is
   begin
      if not Num.IsPositive then
         WriteChar ('-');
      end if;
   end DoSign;

   ---------------------------------------------------------

   procedure PartToString (P    : in     Part;
                           Str  :    out ELStrings.T)
      --# derives Str from P;
   is
      Hi,
      Lo  : Natural;
   begin
      Str := ELStrings.EmptyString;
      Lo := 1;
      Hi := P.Length;
      while Hi >= Lo loop
         Str.Content (Hi) := DigitToChar (P.Numerals (Lo));
         Str.Content (Lo) := DigitToChar (P.Numerals (Hi));
         Lo := Lo + 1;
         Hi := Hi - 1;
      end loop;
      Str.Length := P.Length;
   end PartToString;

   ----------------------------------------------

   procedure IntegerToString
      --# global in     Num;
      --#        in out outBuffer;
      --# derives outBuffer from *,
      --#                        Num;
   is
      ItemBuffer : ELStrings.T;
   begin
      DoSign;
      PartToString (Num.Numerator, ItemBuffer);
      ELStrings.AppendExaminerLongString (OutBuffer, ItemBuffer);
   end IntegerToString;

   ----------------------------------------------

   procedure RealToString
      --# global in     Num;
      --#        in out outBuffer;
      --# derives outBuffer from *,
      --#                        Num;
   is
      ItemBuffer : ELStrings.T;
      IsRational : Boolean;
   begin
      IsRational := not (Num.Denominator = OnePart);
      if IsRational then
         WriteChar ('(');
      end if;
      DoSign;
      PartToString (Num.Numerator, ItemBuffer);
      ELStrings.AppendExaminerLongString (OutBuffer, ItemBuffer);
      if IsRational then
         WriteChar ('/');
         --EStrings.AppendString(outBuffer, "/");
         PartToString (Num.Denominator, ItemBuffer);
         ELStrings.AppendExaminerLongString (OutBuffer, ItemBuffer);
         WriteChar (')');
      end if;
   end RealToString;

   ----------------------------------------------

begin --ValueToString
   if Num.Sort = UnknownValue then
      ELStrings.CopyString (OutBuffer, "unknown value");
   elsif Num.Sort = TruthValue then
      if Num = FalseValue then
         ELStrings.CopyString (OutBuffer, "false");
      else
         ELStrings.CopyString (OutBuffer, "true");
      end if;
   else
      OutBuffer  := ELStrings.EmptyString;
      if Num.Sort = IntegerValue then
         IntegerToString;
      else  --its a real
         RealToString;
      end if;
   end if;
   return OutBuffer;
end ValueToString;
