-- $Id: lists.ads 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with ExaminerConstants;

--# inherit ExaminerConstants;

package Lists
is
   type ListHeap is private;
   type List is private;
   NullList : constant List;

   procedure Init (Heap : out ListHeap);
   --# derives Heap from ;

   procedure NewList (Heap    : in out ListHeap;
                      TheList :    out List;
                      Ok      :    out Boolean);
   --# derives Heap,
   --#         Ok,
   --#         TheList from Heap;


   procedure AddValue (Heap           : in out ListHeap;
                       TheList        : in     List;
                       Value          : in     Natural;
                       AlreadyPresent :    out Boolean;
                       Ok             :    out Boolean);
   --# derives AlreadyPresent,
   --#         Heap,
   --#         Ok             from Heap,
   --#                             TheList,
   --#                             Value;

   procedure GetFirst (Heap    : in out ListHeap;
                       TheList : in out List;
                       Value   :    out Natural;
                       Empty   :    out Boolean;
                       Ok      :    out Boolean);
   --# derives Empty,
   --#         Heap,
   --#         Ok,
   --#         TheList,
   --#         Value   from Heap,
   --#                      TheList;
   -- Removes head of list and returns it.  Ok is false if list illegal.
   -- Empty is true if no value to retieve.
   -- List changes as a result of call but is never deleted even when empty.


   procedure DeleteList (Heap    : in out ListHeap;
                         TheList : in out List);
   --# derives Heap    from *,
   --#                      TheList &
   --#         TheList from ;

   function IsMember (Heap    : ListHeap;
                      TheList : List;
                      Value   : Natural) return Boolean;


   ----------------------------------------------------------------------
   -- Temporary Test Procedures
   ----------------------------------------------------------------------

   --  procedure PrintList(Heap    : ListHeap;
   --                      TheList : List);
   --
   --  procedure PrintHeap(Heap : ListHeap);


   ----------------------------------------------------------------------

private
   type List is range 0 .. ExaminerConstants.ListsHeapSize;
   --# assert List'Base is Integer; -- for the "Large" Examiner

   type HeapElement is record
      Value : Integer;
      Next  : List;
   end record;

   type HeapArrays is array (List) of HeapElement;

   type ListHeap is record
      HeapArray : HeapArrays;
      HighMark  : List;
      FirstFree : List;
   end record;

   NullList : constant List := 0;
end Lists;
