-- $Id: lextokenstacks.ads 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with LexTokenManager;

--# inherit LexTokenManager,
--#         SPARK_IO,
--#         SystemErrors;

package LexTokenStacks
is

   type Stacks is private;

   function IsEmpty (S : Stacks) return Boolean;

   procedure Clear (S : out Stacks);
   --# derives S from ;
   --# post IsEmpty(S);

   procedure Push (S    : in out Stacks;
                   Item : in     LexTokenManager.LexString);
   --# derives S from *,
   --#                Item;

   procedure Pop (S    : in out Stacks;
                  Item :    out LexTokenManager.LexString);
   --# derives Item,
   --#         S    from S;

private
   MaxDepth : constant Integer := 100;
   subtype Ptrs  is Integer range 0 .. MaxDepth;
   subtype Slots is Integer range 1 .. MaxDepth;
   type Vectors is array (Slots) of LexTokenManager.LexString;

   type Stacks is record
      Vector : Vectors;
      Ptr    : Ptrs;
   end record;

end LexTokenStacks;
