-- $Id: lextokenmanager.ads 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================



with ExaminerConstants,
     ELStrings,
     EStrings;

--# inherit Ada.Characters.Handling,
--#         Ada.Characters.Latin_1,
--#         ELStrings,
--#         EStrings,
--#         ExaminerConstants,
--#         SPARK_IO,
--#         Statistics,
--#         SystemErrors;

package LexTokenManager
--# own StringTable : TableStructure;
--# initializes StringTable;
is
   type LexString is private;
   NullString : constant LexString;

   TheFirstToken          : constant LexString;

   -- Common Attributes
   AftToken               : constant LexString;
   BaseToken              : constant LexString;
   DeltaToken             : constant LexString;
   DigitsToken            : constant LexString;
   EmaxToken              : constant LexString;
   EpsilonToken           : constant LexString;
   FirstToken             : constant LexString;
   ForeToken              : constant LexString;
   LargeToken             : constant LexString;
   LastToken              : constant LexString;
   LengthToken            : constant LexString;
   MachineEmaxToken       : constant LexString;
   MachineEminToken       : constant LexString;
   MachineMantissaToken   : constant LexString;
   MachineOverflowsToken  : constant LexString;
   MachineRadixToken      : constant LexString;
   MachineRoundsToken     : constant LexString;
   MantissaToken          : constant LexString;
   PosToken               : constant LexString;
   PredToken              : constant LexString;
   RangeToken             : constant LexString;
   SafeEmaxToken          : constant LexString;
   SafeLargeToken         : constant LexString;
   SafeSmallToken         : constant LexString;
   SizeToken              : constant LexString;
   SmallToken             : constant LexString;
   SuccToken              : constant LexString;
   ValToken               : constant LexString;

   -- Identifiers in Standard
   LeftToken              : constant LexString;
   RightToken             : constant LexString;
   TrueToken              : constant LexString;
   FalseToken             : constant LexString;

   -- Numeric literals
   ZeroValue              : constant LexString;
   OneValue               : constant LexString;

   -- Index file
   SuperIndexToken        : constant LexString;

   -- Pragmas
   InterfaceToken         : constant LexString;
   ImportToken            : constant LexString;
   Link_NameToken         : constant LexString;
   External_NameToken     : constant LexString;
   EntityToken            : constant LexString;
   ConventionToken        : constant LexString;
   Elaborate_BodyToken    : constant LexString;

   -- SPARK95 Predefined packages
   AdaToken               : constant LexString;

   -- SPARK95 Attributes
   DenormToken            : constant LexString;
   Model_EminToken        : constant LexString;
   Model_EpsilonToken     : constant LexString;
   Model_MantissaToken    : constant LexString;
   Model_SmallToken       : constant LexString;
   Safe_FirstToken        : constant LexString;
   Safe_LastToken         : constant LexString;
   Component_SizeToken    : constant LexString;
   MinToken               : constant LexString;
   MaxToken               : constant LexString;
   Signed_ZerosToken      : constant LexString;
   ValidToken             : constant LexString;

   -- More SPARK95 Predefined packages
   CharactersToken        : constant LexString;
   Latin_1Token           : constant LexString;

   -- More SPARK95 Attributes
   AdjacentToken          : constant LexString;
   ComposeToken           : constant LexString;
   Copy_SignToken         : constant LexString;
   Leading_PartToken      : constant LexString;
   RemainderToken         : constant LexString;
   ScalingToken           : constant LexString;
   CeilingToken           : constant LexString;
   ExponentToken          : constant LexString;
   FloorToken             : constant LexString;
   FractionToken          : constant LexString;
   MachineToken           : constant LexString;
   ModelToken             : constant LexString;
   RoundingToken          : constant LexString;
   TruncationToken        : constant LexString;
   Unbiased_RoundingToken : constant LexString;
   AddressToken           : constant LexString;
   ModulusToken           : constant LexString;

   -- SPARK95 Proof Attributes
   TailToken              : constant LexString;
   AppendToken            : constant LexString;

   -- Package System and its constants and types. "Address" is already
   -- defined above.
   SystemToken             : constant LexString;
   Min_IntToken            : constant LexString;
   Max_IntToken            : constant LexString;
   Max_Binary_ModulusToken : constant LexString;
   Max_Base_DigitsToken    : constant LexString;
   Max_DigitsToken         : constant LexString;
   Max_MantissaToken       : constant LexString;
   Fine_DeltaToken         : constant LexString;
   Null_AddressToken       : constant LexString;
   Storage_UnitToken       : constant LexString;
   Word_SizeToken          : constant LexString;
   Any_PriorityToken       : constant LexString;
   PriorityToken           : constant LexString;
   Interrupt_PriorityToken : constant LexString;
   Default_PriorityToken   : constant LexString;

   -- RavenSPARK Pragmas, attributes and packages
   AtomicToken             : constant LexString;
   Real_TimeToken          : constant LexString;
   InheritToken            : constant LexString;
   Synchronous_Task_ControlToken : constant LexString;
   Attach_HandlerToken     : constant LexString;
   Interrupt_HandlerToken  : constant LexString;
   InterruptsToken         : constant LexString;
   AccessToken             : constant LexString;
   Atomic_ComponentsToken  : constant LexString;
   Volatile_ComponentsToken : constant LexString;
   Main_ProgramToken       : constant LexString;

   -- predefined generic units
   Unchecked_ConversionToken : constant LexString;

   -- composite constant rule generation
   RuleToken               : constant LexString;
   NoRuleToken             : constant LexString;

   -- the 'Always_Valid token
   Always_ValidToken       : constant LexString;

   -- Ada0Y identifiers.
   --
   -- "Assert" is a predefined pragma in Ada0Y.  It's already
   -- a reserved word in SPARK, but we still
   -- need a token for it so the corresponding warning can
   -- be suppressed in the warning control file.
   --
   -- There is a special production in the grammar to
   -- allow "pragma Assert ..."
   AssertToken             : constant LexString;

   -- "overriding" will become a pseudo-reserved word in
   -- Ada0Y.  Eventually, we might make it a fully reserved word
   -- in SPARK, but for now let's have a token for it so we
   -- can at least issue a warning
   OverridingToken         : constant LexString;

   -- Package System - more predefined identifiers
   Bit_OrderToken          : constant LexString;
   High_Order_FirstToken   : constant LexString;
   Low_Order_FirstToken    : constant LexString;
   Default_Bit_OrderToken  : constant LexString;

   -- More Pragmas
   All_Calls_RemoteToken   : constant LexString;
   AsynchronousToken       : constant LexString;
   ControlledToken         : constant LexString;
   Discard_NamesToken      : constant LexString;
   ElaborateToken          : constant LexString;
   Elaborate_AllToken      : constant LexString;
   ExportToken             : constant LexString;
   InlineToken             : constant LexString;
   Inspection_PointToken   : constant LexString;
   -- Interrupt_PriorityToken : constant LexString; (already defined)
   Linker_OptionsToken     : constant LexString;
   ListToken               : constant LexString;
   Locking_PolicyToken     : constant LexString;
   Normalize_ScalarsToken  : constant LexString;
   OptimizeToken           : constant LexString;
   PackToken               : constant LexString;
   PageToken               : constant LexString;
   PreelaborateToken       : constant LexString;
   -- PriorityToken           : constant LexString; (already defined)
   PureToken               : constant LexString;
   Queueing_PolicyToken          : constant LexString;
   Remote_Call_InterfaceToken    : constant LexString;
   Remote_TypesToken             : constant LexString;
   RestrictionsToken             : constant LexString;
   ReviewableToken               : constant LexString;
   Shared_PassiveToken           : constant LexString;
   Storage_SizeToken             : constant LexString;
   SuppressToken                 : constant LexString;
   Task_Dispatching_PolicyToken  : constant LexString;
   VolatileToken                 : constant LexString;

   -- More Ada '83 Pragmas
   Memory_SizeToken        : constant LexString;
   SharedToken             : constant LexString;
   -- Storage_UnitToken       : constant LexString;
   System_NameToken        : constant LexString;

   TheLastToken            : constant LexString;

   type LineNumbers is range 0 .. ExaminerConstants.MaxLineNumber;
   --# assert LineNumbers'Base is Integer; -- for the "Large" Examiner

   type TokenPosition is
      record
         StartLineNo : LineNumbers;
         StartPos    : EStrings.Lengths;
      end record;

   type LexValue is
      record
         Position : TokenPosition;
         TokenStr : LexString;
      end record;

   -- Type to identify result of string comparisons
   type StrCompResult is (StrEq, StrFirst, StrSecond);

   -- Performs case insensitive comparison of two LexStrings and
   -- returns a value of type StrCompResult (see above) to indicate
   -- which string comes first when ordered alphabetically.
   -- If both strings are null it returns StrEqual.
   -- If just one string is null then the null string is considered
   -- to come first.
   -- If one string is of length n chars and the other string is
   -- longer but identical for the first n chars then the shorter
   -- string is considered to come first.
   -- (See also CompStr and CompStrCaseSensitive in package body)
   function LexStringCaseInsensitiveCompare
      (LexStr1 : in LexString;
       LexStr2 : in LexString) return StrCompResult;
   --# global in StringTable;

   procedure InsertLexString
      (Str       : in     EStrings.Line;
       StartPos  : in     EStrings.Positions;
       EndPos    : in     EStrings.Positions;
       LexStr    :    out LexString);
   --# global in out StringTable;
   --# derives LexStr,
   --#         StringTable from EndPos,
   --#                          StartPos,
   --#                          Str,
   --#                          StringTable;

   procedure InsertLongLexString
      (Str       : in     ELStrings.Line;
       StartPos  : in     ELStrings.Positions;
       EndPos    : in     ELStrings.Positions;
       LexStr    :    out LexString);
   --# global in out StringTable;
   --# derives LexStr,
   --#         StringTable from EndPos,
   --#                          StartPos,
   --#                          Str,
   --#                          StringTable;

   procedure InsertCaseSensitiveLexString
      (Str       : in     EStrings.Line;
       StartPos  : in     EStrings.Positions;
       EndPos    : in     EStrings.Positions;
       LexStr    :    out LexString);
   --# global in out StringTable;
   --# derives LexStr,
   --#         StringTable from EndPos,
   --#                          StartPos,
   --#                          Str,
   --#                          StringTable;

   procedure InsertExaminerString
      (Str       : in     EStrings.T;
       LexStr    :    out LexString);
   --# global in out StringTable;
   --# derives LexStr,
   --#         StringTable from Str,
   --#                          StringTable;
   --# pre Str.Length >= 1;

   procedure InsertExaminerLongString
      (Str       : in     ELStrings.T;
       LexStr    :    out LexString);
   --# global in out StringTable;
   --# derives LexStr,
   --#         StringTable from Str,
   --#                          StringTable;
   --# pre Str.Length >= 1;

   procedure InsertCaseSensitiveExaminerString
      (Str       : in     EStrings.T;
       LexStr    :    out LexString);
   --# global in out StringTable;
   --# derives LexStr,
   --#         StringTable from Str,
   --#                          StringTable;
   --# pre Str.Length >= 1;

   procedure InsertCaseSensitiveExaminerLongString
      (Str       : in     ELStrings.T;
       LexStr    :    out LexString);
   --# global in out StringTable;
   --# derives LexStr,
   --#         StringTable from Str,
   --#                          StringTable;
   --# pre Str.Length >= 1;

   procedure LexStringToString
      (LexStr   : in     LexString;
       Str      :    out EStrings.T);
   --# global in StringTable;
   --# derives Str from LexStr,
   --#                  StringTable;

   procedure LexStringToLongString
      (LexStr   : in     LexString;
       Str      :    out ELStrings.T);
   --# global in StringTable;
   --# derives Str from LexStr,
   --#                  StringTable;

   function LexStringRef (LexStr : LexString) return Natural;

   function ConvertLexStringRef (LexStrRef : Natural) return LexString;

   function IsAttributeToken (Tok     : LexString;
                              Spark95 : Boolean) return Boolean;

   procedure InitialiseStringTable;
   --# global in out StringTable;
   --# derives StringTable from *;

   procedure ReportUsage;
   --# global in     StringTable;
   --#        in out Statistics.TableUsage;
   --# derives Statistics.TableUsage from *,
   --#                                    StringTable;

   procedure InsertNat (N      : in     Natural;
                        LexStr :    out LexString);
   --# global in out StringTable;
   --# derives LexStr,
   --#         StringTable from N,
   --#                          StringTable;

private
   type LexString is range 0 .. ExaminerConstants.StringTableSize;
   --# assert LexString'Base is Integer;

   NullString : constant LexString := 0;

   TheFirstToken          : constant LexString := 1;
   AftToken               : constant LexString := 1;
   BaseToken              : constant LexString := 8;
   DeltaToken             : constant LexString := 16;
   DigitsToken            : constant LexString := 25;
   EmaxToken              : constant LexString := 35;
   EpsilonToken           : constant LexString := 43;
   FirstToken             : constant LexString := 54;
   ForeToken              : constant LexString := 63;
   LargeToken             : constant LexString := 71;
   LastToken              : constant LexString := 80;
   LengthToken            : constant LexString := 88;
   MachineEmaxToken       : constant LexString := 98;
   MachineEminToken       : constant LexString := 114;
   MachineMantissaToken   : constant LexString := 130;
   MachineOverflowsToken  : constant LexString := 150;
   MachineRadixToken      : constant LexString := 171;
   MachineRoundsToken     : constant LexString := 188;
   MantissaToken          : constant LexString := 206;
   PosToken               : constant LexString := 218;
   PredToken              : constant LexString := 225;
   RangeToken             : constant LexString := 233;
   SafeEmaxToken          : constant LexString := 242;
   SafeLargeToken         : constant LexString := 255;
   SafeSmallToken         : constant LexString := 269;
   SizeToken              : constant LexString := 283;
   SmallToken             : constant LexString := 291;
   SuccToken              : constant LexString := 300;
   ValToken               : constant LexString := 308;
   LeftToken              : constant LexString := 315;
   RightToken             : constant LexString := 323;
   TrueToken              : constant LexString := 332;
   FalseToken             : constant LexString := 340;
   ZeroValue              : constant LexString := 349;
   OneValue               : constant LexString := 354;
   SuperIndexToken        : constant LexString := 359;
   InterfaceToken         : constant LexString := 373;
   ImportToken            : constant LexString := 386;
   Link_NameToken         : constant LexString := 396;
   External_NameToken     : constant LexString := 409;
   EntityToken            : constant LexString := 426;
   ConventionToken        : constant LexString := 436;
   Elaborate_BodyToken    : constant LexString := 450;
   AdaToken               : constant LexString := 468;
   DenormToken            : constant LexString := 475;
   Model_EminToken        : constant LexString := 485;
   Model_EpsilonToken     : constant LexString := 499;
   Model_MantissaToken    : constant LexString := 516;
   Model_SmallToken       : constant LexString := 534;
   Safe_FirstToken        : constant LexString := 549;
   Safe_LastToken         : constant LexString := 563;
   Component_SizeToken    : constant LexString := 576;
   MinToken               : constant LexString := 594;
   MaxToken               : constant LexString := 601;
   Signed_ZerosToken      : constant LexString := 608;
   ValidToken             : constant LexString := 624;
   CharactersToken        : constant LexString := 633;
   Latin_1Token           : constant LexString := 647;
   AdjacentToken          : constant LexString := 658;
   ComposeToken           : constant LexString := 670;
   Copy_SignToken         : constant LexString := 681;
   Leading_PartToken      : constant LexString := 694;
   RemainderToken         : constant LexString := 710;
   ScalingToken           : constant LexString := 723;
   CeilingToken           : constant LexString := 734;
   ExponentToken          : constant LexString := 745;
   FloorToken             : constant LexString := 757;
   FractionToken          : constant LexString := 766;
   MachineToken           : constant LexString := 778;
   ModelToken             : constant LexString := 789;
   RoundingToken          : constant LexString := 798;
   TruncationToken        : constant LexString := 810;
   Unbiased_RoundingToken : constant LexString := 824;
   AddressToken           : constant LexString := 845;
   ModulusToken           : constant LexString := 856;
   TailToken              : constant LexString := 867;
   AppendToken            : constant LexString := 875;

   -- System and its constants and types. "Address" is already
   -- defined above.
   SystemToken             : constant LexString := 885;
   Min_IntToken            : constant LexString := 895;
   Max_IntToken            : constant LexString := 906;
   Max_Binary_ModulusToken : constant LexString := 917;
   Max_Base_DigitsToken    : constant LexString := 939;
   Max_DigitsToken         : constant LexString := 958;
   Max_MantissaToken       : constant LexString := 972;
   Fine_DeltaToken         : constant LexString := 988;
   Null_AddressToken       : constant LexString := 1002;
   Storage_UnitToken       : constant LexString := 1018;
   Word_SizeToken          : constant LexString := 1034;
   Any_PriorityToken       : constant LexString := 1047;
   PriorityToken           : constant LexString := 1063;
   Interrupt_PriorityToken : constant LexString := 1075;
   Default_PriorityToken   : constant LexString := 1097;

   -- RavenSPARK Pragmas, attributes, and identifiers
   AtomicToken             : constant LexString := 1117;
   Real_TimeToken          : constant LexString := 1127;
   InheritToken            : constant LexString := 1140;
   Synchronous_Task_ControlToken : constant LexString := 1151;
   Attach_HandlerToken     : constant LexString := 1179;
   Interrupt_HandlerToken  : constant LexString := 1197;
   InterruptsToken         : constant LexString := 1218;
   AccessToken             : constant LexString := 1232;
   Atomic_ComponentsToken  : constant LexString := 1242;
   Volatile_ComponentsToken : constant LexString := 1263;
   Main_ProgramToken       : constant LexString := 1286;

   -- Ada0Y identifiers.
   AssertToken             : constant LexString := 1302;
   OverridingToken         : constant LexString := 1312;

   -- Predefined generics
   Unchecked_ConversionToken : constant LexString := 1326;

   -- Composite constant rule generation
   RuleToken               : constant LexString := 1350;
   NoRuleToken             : constant LexString := 1358;

   -- the 'Always_Valid token
   Always_ValidToken       : constant LexString := 1368;

   Bit_OrderToken          : constant LexString := 1384;
   High_Order_FirstToken   : constant LexString := 1397;
   Low_Order_FirstToken    : constant LexString := 1417;
   Default_Bit_OrderToken  : constant LexString := 1436;

   -- More Pragmas
   All_Calls_RemoteToken   : constant LexString := 1457;
   AsynchronousToken       : constant LexString := 1477;
   ControlledToken         : constant LexString := 1493;
   Discard_NamesToken      : constant LexString := 1507;
   ElaborateToken          : constant LexString := 1524;
   Elaborate_AllToken      : constant LexString := 1537;
   ExportToken             : constant LexString := 1554;
   InlineToken             : constant LexString := 1564;
   Inspection_PointToken   : constant LexString := 1574;
   Linker_OptionsToken     : constant LexString := 1594;
   ListToken               : constant LexString := 1612;
   Locking_PolicyToken     : constant LexString := 1620;
   Normalize_ScalarsToken  : constant LexString := 1638;
   OptimizeToken           : constant LexString := 1659;
   PackToken               : constant LexString := 1671;
   PageToken               : constant LexString := 1679;
   PreelaborateToken       : constant LexString := 1687;
   PureToken               : constant LexString := 1703;
   Queueing_PolicyToken          : constant LexString := 1711;
   Remote_Call_InterfaceToken    : constant LexString := 1730;
   Remote_TypesToken             : constant LexString := 1755;
   RestrictionsToken             : constant LexString := 1771;
   ReviewableToken               : constant LexString := 1787;
   Shared_PassiveToken           : constant LexString := 1801;
   Storage_SizeToken             : constant LexString := 1819;
   SuppressToken                 : constant LexString := 1835;
   Task_Dispatching_PolicyToken  : constant LexString := 1847;
   VolatileToken                 : constant LexString := 1874;

   -- More Ada '83 Pragmas
   Memory_SizeToken        : constant LexString := 1886;
   SharedToken             : constant LexString := 1901;
   -- Storage_UnitToken       : constant LexString := 1955; -50
   System_NameToken        : constant LexString := 1911;

   -- Next token value is
   -- System_NameToken + Length("System_Name") + 4 = 1911 + 11 + 4 = 1926

   -- See S.P0468.53.1 "Implementation and Testing of the Lexical
   -- Token Manager"

   TheLastToken          : constant LexString := 1911;

end LexTokenManager;
