-- $Id: lextokenmanager-insertnat.adb 11889 2008-12-12 15:49:12Z rod chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with SPARK_IO;

separate (LexTokenManager)
procedure InsertNat (N      : in     Natural;
                     LexStr :    out LexString)
is
   ExStr : EStrings.Contents;
   ExLin : EStrings.Line;
   Wid   : EStrings.Lengths;

   function Width (N : Natural) return Natural
   is
      Num,
      Wid : Natural;
   begin
      Num := N;
      Wid := 0;
      loop
         Num := Num / 10;
         Wid := Wid + 1;
         exit when Num = 0;
      end loop;
      return Wid;
   end Width;

begin -- InsertNat
   Wid := Width (N);
   SPARK_IO.Put_Int_To_String (ExStr, N, 1, 10);

   -- Initialize ExLin fully to avoid subsequent DF error(s)
   ExLin := EStrings.EmptyLine;
   for I in EStrings.Lengths range 1 .. Wid loop
      ExLin (I) := ExStr ((EStrings.MaxStringLength - Wid) + I);
   end loop;

   InsertLexString (ExLin, 1, Wid, LexStr);
end InsertNat;
