-- $Id: lextokenlists.ads 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with LexTokenManager,
     ExaminerConstants;

use type LexTokenManager.LexString;

--# inherit ExaminerConstants,
--#         LexTokenManager,
--#         SystemErrors;

package LexTokenLists
is
   subtype Lengths is Integer range 0 .. ExaminerConstants.LexTokenListsMaxLength;

   subtype Positions is Lengths range 1 .. ExaminerConstants.LexTokenListsMaxLength;

   type Contents is array (Positions) of LexTokenManager.LexString;

   type Lists is record
      Length  : Lengths;
      Content : Contents;
   end record;

   NullList : constant Lists :=
      Lists'(0, Contents'(Positions => LexTokenManager.NullString));

   function PrefixUnit (PossPrefix, Prefixed : Lists) return Boolean;

   function EqUnit (FirstItem, Second : Lists) return Boolean;

   procedure Append (List : in out Lists;
                     Item : in     LexTokenManager.LexString);
   --# derives List from *,
   --#                   Item;

end LexTokenLists;
