-- $Id: lextokenlists.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with SystemErrors;

package body LexTokenLists
is

   function PrefixUnit (PossPrefix, Prefixed : Lists) return Boolean
   is
      Result : Boolean;
   begin
      if PossPrefix.Length <= Prefixed.Length then
         Result := True;
         for I in Positions range 1 .. PossPrefix.Length loop
            Result := Result and PossPrefix.Content (I) = Prefixed.Content (I);
            exit when not Result;
         end loop;
      else
         Result := False;
      end if;
      return Result;
   end PrefixUnit;

   function EqUnit (FirstItem, Second : Lists) return Boolean
   is
      Result : Boolean;
   begin
      if FirstItem.Length = Second.Length then
         Result := True;
         for I in Positions range 1 .. FirstItem.Length loop
            Result := Result and FirstItem.Content (I) = Second.Content (I);
            exit when not Result;
         end loop;
      else
         Result := False;
      end if;
      return Result;
   end EqUnit;

   procedure Append (List : in out Lists;
                     Item : in     LexTokenManager.LexString)
   is
   begin
      if List.Length = ExaminerConstants.LexTokenListsMaxLength then
         SystemErrors.FatalError (SystemErrors.UnitNestingTooDeep, "in LexTokenLists");
      end if;

      List.Length := List.Length + 1;
      List.Content (List.Length) := Item;
   end Append;

end LexTokenLists;
