-- $Id: indexmanager.ads 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with SPARK_IO,
     ContextManager,
     EStrings,
     ExaminerConstants,
     LexTokenLists;

use type SPARK_IO.File_Status;

--# inherit Ada.Characters.Latin_1,
--#         CommandLineData,
--#         ContextManager,
--#         EStrings,
--#         ExaminerConstants,
--#         FileSystem,
--#         LexTokenLists,
--#         LexTokenManager,
--#         ScreenEcho,
--#         SPARK_IO,
--#         SystemErrors,
--#         XMLReport;

package IndexManager
--# own IndexTable : IndexTables;
--#     LastChar   : Character;
--# initializes IndexTable,
--#             LastChar;
is
   subtype ComponentIndex is Integer range 1 .. ExaminerConstants.MaxIndexComponents;

   type ComponentLists is array (ComponentIndex) of LexTokenLists.Lists;

   procedure LookUp (RequiredUnit      : in     LexTokenLists.Lists;
                     PossibleUnitTypes : in     ContextManager.UnitTypeSets;
                     SourceFileName    :    out EStrings.T;
                     ActualUnitType    :    out ContextManager.UnitTypes;
                     Found            :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in out IndexTable;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.File_Sys;
   --#           out LastChar;
   --# derives ActualUnitType,
   --#         Found,
   --#         LastChar,
   --#         SourceFileName              from CommandLineData.Content,
   --#                                          LexTokenManager.StringTable,
   --#                                          PossibleUnitTypes,
   --#                                          RequiredUnit,
   --#                                          SPARK_IO.File_Sys &
   --#         IndexTable,
   --#         LexTokenManager.StringTable,
   --#         SPARK_IO.File_Sys           from *,
   --#                                          CommandLineData.Content,
   --#                                          LexTokenManager.StringTable,
   --#                                          PossibleUnitTypes,
   --#                                          RequiredUnit,
   --#                                          SPARK_IO.File_Sys;

   procedure LookUpComponents (ParentUnit : in     LexTokenLists.Lists;
                               Components :    out ComponentLists);
   --# global in     CommandLineData.Content;
   --#        in out IndexTable;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.File_Sys;
   --#           out LastChar;
   --# derives Components,
   --#         LastChar                    from CommandLineData.Content,
   --#                                          LexTokenManager.StringTable,
   --#                                          ParentUnit,
   --#                                          SPARK_IO.File_Sys &
   --#         IndexTable,
   --#         LexTokenManager.StringTable,
   --#         SPARK_IO.File_Sys           from *,
   --#                                          CommandLineData.Content,
   --#                                          LexTokenManager.StringTable,
   --#                                          ParentUnit,
   --#                                          SPARK_IO.File_Sys;

   procedure ListIndexFile (ReportFile : in SPARK_IO.File_Type);
   --# global in     CommandLineData.Content;
   --#        in     IndexTable;
   --#        in out SPARK_IO.File_Sys;
   --#        in out XMLReport.State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                IndexTable,
   --#                                ReportFile,
   --#                                XMLReport.State &
   --#         XMLReport.State   from *,
   --#                                CommandLineData.Content,
   --#                                IndexTable;
end IndexManager;
