-- $Id: flowanalyser.ads 12319 2009-01-28 12:49:09Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with STree,
     Dictionary,
     LexTokenManager,
     Heap,
     RefList,
     ComponentManager;

use type Dictionary.Symbol;
use type STree.SyntaxNode;
use type Heap.Atom;
use type Dictionary.Modes;

--# inherit CommandLineData,
--#         ComponentErrors,
--#         ComponentManager,
--#         Debug,
--#         Dictionary,
--#         ErrorHandler,
--#         ExaminerConstants,
--#         Heap,
--#         LexTokenManager,
--#         RefList,
--#         RelationAlgebra,
--#         RelationAlgebra.Debug,
--#         SeqAlgebra,
--#         SPARK_IO,
--#         SPSymbols,
--#         Statistics,
--#         STree,
--#         SystemErrors;
package FlowAnalyser
is
   procedure FlowAnalyse (SubprogSym         : in     Dictionary.Symbol;
                          StartNode          : in     STree.SyntaxNode;
                          EndPosition        : in     LexTokenManager.TokenPosition;
                          ComponentData      : in out ComponentManager.ComponentData;
                          TheHeap            : in out Heap.HeapRecord;
                          Table              : in     RefList.HashTable;
                          DataFlowErrorFound :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --# derives ComponentData,
   --#         Statistics.TableUsage,
   --#         TheHeap                   from *,
   --#                                        CommandLineData.Content,
   --#                                        ComponentData,
   --#                                        Dictionary.Dict,
   --#                                        EndPosition,
   --#                                        StartNode,
   --#                                        STree.Table,
   --#                                        SubprogSym,
   --#                                        Table,
   --#                                        TheHeap &
   --#         DataFlowErrorFound        from ComponentData,
   --#                                        Dictionary.Dict,
   --#                                        EndPosition,
   --#                                        StartNode,
   --#                                        STree.Table,
   --#                                        SubprogSym,
   --#                                        Table,
   --#                                        TheHeap &
   --#         ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        ComponentData,
   --#                                        Dictionary.Dict,
   --#                                        EndPosition,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        StartNode,
   --#                                        STree.Table,
   --#                                        SubprogSym,
   --#                                        Table,
   --#                                        TheHeap;


   procedure FlowAnalysePartition (Node    : in STree.SyntaxNode;
                                   TheHeap : in out Heap.HeapRecord);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        Node,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        STree.Table,
   --#                                        TheHeap &
   --#         Statistics.TableUsage,
   --#         TheHeap                   from *,
   --#                                        Dictionary.Dict,
   --#                                        TheHeap;
   --# pre STree.SyntaxNodeType (Node, STree.Table) =
   --#        SPSymbols.main_program_declaration;

end FlowAnalyser;
