-- $Id: flowanalyser-flowanalyse-analyserelations-checkdependencies.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (FlowAnalyser.FlowAnalyse.AnalyseRelations)
procedure CheckDependencies
is
   IntersectionSeq,
   DependencyCol,
   RhoCol,
   RhoRow                : SeqAlgebra.Seq;
   MemberOfInitVars,
   MemberOfExports       : SeqAlgebra.MemberOfSeq;
   InitVarRep,
   ExpVarRep             : Natural;
   InitVar,
   ExportVar             : Dictionary.Symbol;
   ExportLeaves          : SeqAlgebra.Seq;
   MemberOfExportLeaves  : SeqAlgebra.MemberOfSeq;
   ExportLeafRep         : Natural;
   LeafRhoCol            : SeqAlgebra.Seq;
   NewError              : Natural;
   MemberOfDependencyCol : SeqAlgebra.MemberOfSeq;
   DepRep                : Natural;
   DepSym                : Dictionary.Symbol;
   DepLeaves             : SeqAlgebra.Seq;
   MemberOfRhoCol        : SeqAlgebra.MemberOfSeq;
   RhoSym                : Dictionary.Symbol;
   RhoRep                : Natural;
   RootRhoRep            : Natural;
   PreservedVars         : SeqAlgebra.Seq;
   PreservedExportLeaves : SeqAlgebra.Seq;


   function IsNonLeafRecord (Sym : Dictionary.Symbol) return Boolean
   --# global in ComponentData;
   --#        in Dictionary.Dict;
   is
   begin
      return  Dictionary.IsVariable (Sym) and then
         Dictionary.TypeIsRecord (Dictionary.GetType (Sym)) and then
         ComponentManager.HasChildren (ComponentData,
                                       ComponentManager.GetComponentNode (ComponentData, Sym));
   end IsNonLeafRecord;

   ------------------------

   function EmptyIntersection (A, B : SeqAlgebra.Seq) return Boolean
   --# global in TheHeap;
   is
      Empty : Boolean := True;
      M,
      N        : SeqAlgebra.MemberOfSeq;
      ValueOfM,
      ValueOfN : Natural;
   begin
      M := SeqAlgebra.FirstMember (TheHeap, A);
      N := SeqAlgebra.FirstMember (TheHeap, B);
      loop
         exit when SeqAlgebra.IsNullMember (M) or SeqAlgebra.IsNullMember (N);
         ValueOfM := SeqAlgebra.ValueOfMember (TheHeap, M);
         ValueOfN := SeqAlgebra.ValueOfMember (TheHeap, N);
         if ValueOfM < ValueOfN then
            M := SeqAlgebra.NextMember (TheHeap, M);
         elsif ValueOfM > ValueOfN then
            N := SeqAlgebra.NextMember (TheHeap, N);
         else --equal values, intersection is not empty
            Empty := False;
         end if;
         exit when not Empty;
      end loop;
      return Empty;
   end EmptyIntersection;

   ------------------------

begin --CheckDependencies
      -- check effectiveness of initializations of package own variables;
   MemberOfInitVars := SeqAlgebra.FirstMember (TheHeap, SeqOfInitVars);
   while not SeqAlgebra.IsNullMember (MemberOfInitVars) loop
      InitVarRep := SeqAlgebra.ValueOfMember (TheHeap, MemberOfInitVars);
      InitVar := Dictionary.ConvertSymbolRef (ExaminerConstants.RefType (InitVarRep));
      RelationAlgebra.RowExtraction (TheHeap, IFA_Stack.Top (S).Rho, InitVarRep, RhoRow);
      SeqAlgebra.Intersection (TheHeap, RhoRow, ExpSeqOfExports, IntersectionSeq);
      if SeqAlgebra.IsEmptySeq (TheHeap, IntersectionSeq) then
         if Dictionary.IsRecordSubcomponent (InitVar) then
            ComponentErrors.CreateError (TheErrorHeap,
                                         TheHeap,
                                         ComponentErrors.Dependency,
                                         ErrorHandler.DependencyErrType'Pos
                                         (ErrorHandler.IneffInit),
                                         EndPosition,
                                         Dictionary.NullSymbol,
                                          --to get
                                         NewError);
            ComponentManager.AddError (TheHeap,
                                       TheErrorHeap,
                                       ComponentData,
                                       ComponentManager.GetComponentNode
                                       (ComponentData, InitVar),
                                       NewError);
         else
            ErrorHandler.DependencyError (ErrorHandler.IneffInit,
                                          EndPosition,
                                          InitVar,
                                          Dictionary.NullSymbol,
                                          Scope);
         end if;
      end if;
      SeqAlgebra.DisposeOfSeq (TheHeap, RhoRow);
      SeqAlgebra.DisposeOfSeq (TheHeap, IntersectionSeq);
      MemberOfInitVars := SeqAlgebra.NextMember (TheHeap, MemberOfInitVars);
   end loop;

   --calculate preserved vars for use in implicit record self-dependency
   SeqAlgebra.Complement (TheHeap,
                          IFA_Stack.Top (S).AllVars,
                          IFA_Stack.Top (S).UnPreservedVars,
                           --to get
                          PreservedVars);

   MemberOfExports := SeqAlgebra.FirstMember (TheHeap, SeqOfExports);
   while not SeqAlgebra.IsNullMember (MemberOfExports) loop
      ExpVarRep := SeqAlgebra.ValueOfMember (TheHeap, MemberOfExports);
      ExportVar := Dictionary.ConvertSymbolRef (ExaminerConstants.RefType (ExpVarRep));

      -- Do not process any dependency stuff associated with implicit exports of mode in
      if Dictionary.GetOwnVariableOrConstituentMode (ExportVar) /= Dictionary.InMode and then
         -- nor anything to do with exporting of the "data sink" null variable
        ExportVar /= Dictionary.GetNullVariable and then
         -- nor updates of implicit in streams associated with protected state
        not Dictionary.IsProtectedImplicitInStream (ExportVar) then

         RelationAlgebra.ColExtraction (TheHeap,
                                        DependencyRelation,
                                        SeqAlgebra.ValueOfMember (TheHeap, MemberOfExports),
                                          --to get
                                        DependencyCol);
         if IsNonLeafRecord (ExportVar) then       -- 9.3.2 (3) of S.P0466.53.9
            SeqAlgebra.CreateSeq (TheHeap, RhoCol);
            ComponentManager.GetLeaves (TheHeap,
                                        ComponentData,
                                        ComponentManager.GetComponentNode (ComponentData,
                                                                           ExportVar),
                                          --to get
                                        ExportLeaves);
            MemberOfExportLeaves := SeqAlgebra.FirstMember (TheHeap, ExportLeaves);
            while not SeqAlgebra.IsNullMember (MemberOfExportLeaves)
            loop
               ExportLeafRep := SeqAlgebra.ValueOfMember (TheHeap, MemberOfExportLeaves);
               RelationAlgebra.ColExtraction (TheHeap,
                                              IFA_Stack.Top (S).Rho,
                                              ExportLeafRep,
                                                --to get
                                              LeafRhoCol);
               SeqAlgebra.AugmentSeq (TheHeap,
                                      RhoCol,
                                          --with
                                      LeafRhoCol);
               SeqAlgebra.DisposeOfSeq (TheHeap,
                                        LeafRhoCol);

               MemberOfExportLeaves := SeqAlgebra.NextMember (TheHeap, MemberOfExportLeaves);
            end loop;

            --added this to handle implicit dependency of record on itself
            SeqAlgebra.Intersection (TheHeap,
                                     PreservedVars,
                                     ExportLeaves,
                                       --to get
                                     PreservedExportLeaves);
            SeqAlgebra.AugmentSeq (TheHeap,
                                   RhoCol,
                                    --with
                                   PreservedExportLeaves);
         else
            RelationAlgebra.ColExtraction (TheHeap,
                                           IFA_Stack.Top (S).Rho,
                                           ExpVarRep,
                                             --to get
                                           RhoCol);
         end if;

         MemberOfDependencyCol := SeqAlgebra.FirstMember (TheHeap, DependencyCol);
         while  CommandLineData.Content.DoInformationFlow and then
            not SeqAlgebra.IsNullMember (MemberOfDependencyCol)
         loop
            DepRep := SeqAlgebra.ValueOfMember (TheHeap, MemberOfDependencyCol);
            DepSym := Dictionary.ConvertSymbolRef (ExaminerConstants.RefType (DepRep));

            if IsNonLeafRecord (DepSym) then
               ComponentManager.GetLeaves (TheHeap,
                                           ComponentData,
                                           ComponentManager.GetComponentNode (ComponentData,
                                                                              DepSym),
                                             --to get
                                           DepLeaves);
               if EmptyIntersection (DepLeaves, RhoCol) then
                  ErrorHandler.DependencyError (ErrorHandler.NotUsed,
                                                EndPosition,
                                                DepSym,
                                                ExportVar,
                                                Scope);
               end if;
            else
               if not SeqAlgebra.IsMember (TheHeap, RhoCol, DepRep) then
                  ErrorHandler.DependencyError (ErrorHandler.NotUsed,
                                                EndPosition,
                                                DepSym,
                                                ExportVar,
                                                Scope);
               end if;
            end if;
            MemberOfDependencyCol := SeqAlgebra.NextMember (TheHeap, MemberOfDependencyCol);
         end loop;

         -- start of 9.3.3 of S.P0468.53.9
         SeqAlgebra.Reduction (TheHeap, RhoCol, SeqOfInitVars);
         MemberOfRhoCol := SeqAlgebra.FirstMember (TheHeap, RhoCol);
         while not SeqAlgebra.IsNullMember (MemberOfRhoCol)
         loop
            RhoRep := SeqAlgebra.ValueOfMember (TheHeap, MemberOfRhoCol);
            RhoSym := Dictionary.ConvertSymbolRef (ExaminerConstants.RefType (RhoRep));
            --add guard to prevent dependencies on OUT streams being reported
            if Dictionary.GetOwnVariableOrConstituentMode
              (Dictionary.GetMostEnclosingObject (RhoSym)) /= Dictionary.OutMode then
               if Dictionary.IsRecordSubcomponent (RhoSym) then
                  RootRhoRep := Natural (Dictionary.SymbolRef
                                         (ComponentManager.GetName
                                          (ComponentData,
                                           ComponentManager.GetRoot
                                           (ComponentData,
                                            ComponentManager.GetComponentNode (ComponentData,
                                                                               RhoSym)))));
                  if not SeqAlgebra.IsMember (TheHeap, DependencyCol, RootRhoRep) then
                     if SeqAlgebra.IsMember (TheHeap, SeqOfImports, RootRhoRep) then
                        ComponentErrors.CreateError (TheErrorHeap,
                                                     TheHeap,
                                                     ComponentErrors.Dependency,
                                                     ErrorHandler.DependencyErrType'Pos
                                                     (ErrorHandler.MayBeUsed),
                                                     EndPosition,
                                                     ExportVar,
                                                      --to get
                                                     NewError);
                     else
                        ComponentErrors.CreateError (TheErrorHeap,
                                                     TheHeap,
                                                     ComponentErrors.Dependency,
                                                     ErrorHandler.DependencyErrType'Pos
                                                     (ErrorHandler.Uninitialised),
                                                     EndPosition,
                                                     ExportVar,
                                                      --to get
                                                     NewError);
                     end if;
                     ComponentManager.AddError (TheHeap,
                                                TheErrorHeap,
                                                ComponentData,
                                                ComponentManager.GetComponentNode (ComponentData,
                                                                                   RhoSym),
                                                NewError);
                  end if;

               else --not a record or an entire record
                  if not SeqAlgebra.IsMember (TheHeap, DependencyCol, RhoRep) then
                     if SeqAlgebra.IsMember (TheHeap, SeqOfImports, RhoRep) then

                        if Dictionary.RelationViolatesInfoFlowPolicy (ExportVar, RhoSym) then
                           ErrorHandler.DependencyError (ErrorHandler.MayBeIntegrityViolation,
                                                         EndPosition,
                                                         RhoSym,
                                                         ExportVar,
                                                         Scope);
                        else
                           ErrorHandler.DependencyError (ErrorHandler.MayBeUsed,
                                                         EndPosition,
                                                         RhoSym,
                                                         ExportVar,
                                                         Scope);
                        end if;


                     else
                        ErrorHandler.DependencyError (ErrorHandler.Uninitialised,
                                                      EndPosition,
                                                      RhoSym,
                                                      ExportVar,
                                                      Scope);
                     end if;
                  end if;
               end if;
            end if;
            MemberOfRhoCol := SeqAlgebra.NextMember (TheHeap, MemberOfRhoCol);
         end loop;

         SeqAlgebra.DisposeOfSeq (TheHeap, DependencyCol);
         SeqAlgebra.DisposeOfSeq (TheHeap, RhoCol);
      end if; -- ignoring exports of mode in and exports that are null variables (data sinks)
      MemberOfExports := SeqAlgebra.NextMember (TheHeap, MemberOfExports);
   end loop;
   SeqAlgebra.DisposeOfSeq (TheHeap, PreservedVars);
end CheckDependencies;
