-- $Id: errorhandler-printline.adb 11889 2008-12-12 15:49:12Z rod chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler)
procedure PrintLine (Listing  : in SPARK_IO.File_Type;
                     StartPos,
                     EndPos,
                     Indent   : in Natural;
                     Line     : in ELStrings.T;
                     NewLine  : in Boolean;
                     NewStart : out Natural)
is
   Pos,
   CurrentLineEnd,
   CurrentLineStart : Natural;

   procedure Print_Current_Line
   --# global in     CurrentLineEnd;
   --#        in     CurrentLineStart;
   --#        in     Line;
   --#        in     Listing;
   --#        in     NewLine;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CurrentLineEnd,
   --#                                CurrentLineStart,
   --#                                Line,
   --#                                Listing,
   --#                                NewLine;
   is
   begin
      for Ix in Natural range CurrentLineStart .. CurrentLineEnd
      loop
         Put_Char (Listing, Line.Content (Ix));
      end loop;
      if CurrentLineEnd /= Line.Length or NewLine then
         New_Line (Listing, 1);
      end if;
   end Print_Current_Line;

   procedure Find_Current_Line_End (CurrentLinePos : in Natural)
   --# global in     CurrentLineStart;
   --#        in     EndPos;
   --#        in     Line;
   --#        in     Pos;
   --#           out CurrentLineEnd;
   --# derives CurrentLineEnd from CurrentLinePos,
   --#                             CurrentLineStart,
   --#                             EndPos,
   --#                             Line,
   --#                             Pos;
   is
      NextSpacePos,
      CurrentSpacePos : Integer;

      function FindNextSpace (CurrPos : in Natural) return Natural
      --# global in Line;
      is
         NextPos : Natural;
      begin
         NextPos := CurrPos;
         loop
            exit when NextPos = Line.Length;
            NextPos := NextPos + 1;
            exit when Line.Content (NextPos) = ' ';
         end loop;
         return NextPos;
      end FindNextSpace;

   begin
      if EndPos = 0 then
         CurrentLineEnd := Line.Length;
      else
         CurrentSpacePos := FindNextSpace (CurrentLinePos);
         loop
            exit when CurrentSpacePos = Line.Length;
            NextSpacePos := FindNextSpace (CurrentSpacePos);
            exit when (Pos + NextSpacePos) - CurrentLineStart >= EndPos;
            CurrentSpacePos := NextSpacePos;
         end loop;
         CurrentLineEnd := CurrentSpacePos;
      end if;
   end Find_Current_Line_End;

begin
   CurrentLineStart := 1;
   Pos := StartPos;
   Find_Current_Line_End (0);
   loop
      Print_Current_Line;
      exit when CurrentLineEnd = Line.Length;
      PutSpaces (Listing, Indent);
      Pos := Indent;
      CurrentLineStart := CurrentLineEnd + 1;
      Find_Current_Line_End (CurrentLineStart);
   end loop;
   NewStart := Pos + ((CurrentLineEnd + 1) - CurrentLineStart);
end PrintLine;
