-- $Id: errorhandler-getfileline.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler)
procedure GetFileLine
is
   CurLine         : EStrings.T;
   LineNoBeforeGet : LexTokenManager.LineNumbers;
begin
   -- Handling of line containing eight-bit characters
   if SPARK_IO.End_Of_Line (ErrorContextRec.Source) then
      SPARK_IO.Skip_Line (ErrorContextRec.Source, 1);
      ErrorContextRec.LineNo := ErrorContextRec.LineNo + 1;
      ErrorContextRec.CurrentLine.Length := 0;
   else
      LineNoBeforeGet := LexTokenManager.LineNumbers (SPARK_IO.Line (ErrorContextRec.Source));
      EStrings.GetLine (ErrorContextRec.Source,
                               CurLine);
      ErrorContextRec.CurrentLine := CurLine;
      ErrorContextRec.LineNo := ErrorContextRec.LineNo + 1;
      if ErrorContextRec.CurrentLine.Length = 0 then
         EStrings.CopyString (CurLine,
                                     " -- *** ILLEGAL LINE REPLACED *** --");
         ErrorContextRec.CurrentLine := CurLine;
      end if;
      if LineNoBeforeGet =
         LexTokenManager.LineNumbers (SPARK_IO.Line (ErrorContextRec.Source))
      then
         SPARK_IO.Skip_Line (ErrorContextRec.Source, 1);
      end if;
   end if;
end GetFileLine;
