-- $Id: errorhandler-erroraccumulator.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (ErrorHandler)
package body ErrorAccumulator
is

   -----------------------------------------------------------------------------

   function IsActive (This : T) return Boolean
   is
   begin
      return This.Active;
   end IsActive;

   function IsErrorContinuation (TheError : Error_Types.StringError) return Boolean
   is
   begin
      return ((TheError.ErrorType = Error_Types.CondlDependencyErr and then
                 TheError.MessageId = ErrorHandler.DependencyErrNumber (ErrorHandler.MayBeUsedContinue)) or else
                (TheError.ErrorType = Error_Types.UncondDependencyErr and then
                   TheError.MessageId = ErrorHandler.DependencyErrNumber (ErrorHandler.NotUsedContinue)));
   end IsErrorContinuation;

   function IsErrorStart (TheError : Error_Types.StringError) return Boolean
   is
   begin
      return ((TheError.ErrorType = Error_Types.CondlDependencyErr and then
                 TheError.MessageId = ErrorHandler.DependencyErrNumber (ErrorHandler.MayBeUsedNew)) or else
                (TheError.ErrorType = Error_Types.UncondDependencyErr and then
                   TheError.MessageId = ErrorHandler.DependencyErrNumber (ErrorHandler.NotUsedNew)));
   end IsErrorStart;


   procedure StartMsg (This        :    out T;
                       StartError  : in     ErrorHandler.ErrorStruct;
                       StartIndent : in     Natural;
                       Explanation : in     ELStrings.T;
                       LineLength  : in     Natural;
                       Indent      : in     Natural)
   is
   begin
      This := T'(Active      => True,
                 StartError  => StartError,
                 StartIndent => StartIndent,
                 Explanation => Explanation,
                 LineLength => LineLength,
                 Indent => Indent);

   end StartMsg;

   procedure Flush (This    : in out T;
                    Listing  : in     SPARK_IO.File_Type)
   is
      UnusedNewStart : Natural;
   begin
      if This.Active then
         if This.Explanation /= ELStrings.EmptyString then
            --# accept F, 10, UnusedNewStart, "Expected ineffective assignment";
            ErrorHandler.PrintLine (Listing  => Listing,
                                    StartPos => This.StartIndent,
                                    EndPos   => This.LineLength,
                                    Indent   => This.Indent,
                                    Line     => This.Explanation,
                                    NewLine  => False,
                                    NewStart => UnusedNewStart);
            --# end accept;
         end if;
         ErrorHandler.Put_String (Listing, ".", 1);
         This.Active := False;
      end if;
      --# accept Flow, 33, UnusedNewStart, "Expected to be neither referenced nor exported";
   end Flush;

   procedure Add (This     : in out T;
                  Error    : in     ErrorHandler.ErrorStruct;
                  EndPos,
                  Indent   : in     Natural;
                  Listing  : in     SPARK_IO.File_Type)
   is

      NewStart : Natural;

      function NeedToAdd return Boolean
      --# global in Error;
      --#        in This;
      is
      begin
         return (This.StartError.Error.MessageId =
                   ErrorHandler.DependencyErrNumber (ErrorHandler.MayBeUsedNew) and
                   Error.Error.ErrorType = Error_Types.CondlDependencyErr and
                   Error.Error.MessageId =
                   ErrorHandler.DependencyErrNumber (ErrorHandler.MayBeUsedContinue)) or else

           (This.StartError.Error.MessageId =
              ErrorHandler.DependencyErrNumber (ErrorHandler.NotUsedNew) and
              Error.Error.ErrorType = Error_Types.UncondDependencyErr and
              Error.Error.MessageId =
              ErrorHandler.DependencyErrNumber (ErrorHandler.NotUsedContinue));
      end NeedToAdd;


   begin
      if This.Active then
         if NeedToAdd then

            ErrorHandler.PrintLine (Listing, This.StartIndent, EndPos, Indent,
                                    Error.Error.Message, False, NewStart);
            This.StartIndent := NewStart;

         elsif IsErrorContinuation (Error.Error) then

            SystemErrors.FatalError (SystemErrors.OtherInternalError,
                                     "in ErrorHandler.ErrorAccumulator.Add");
         else

            Flush (This, Listing);

         end if;
      end if;

   end Add;


end ErrorAccumulator;
