-- $Id: errorhandler-conversions.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler)
package body Conversions
--# own State is SourceUsed, ExplanationTable;
is

   -------------------------------------------------------------------

   type Sources is (Nul, LRM, SR95, SR83, UM, VCGUM, RTCUM, JB);
   type SourcesUsed is array (Sources) of Boolean;
   NoSourceUsed : constant SourcesUsed := SourcesUsed'(Sources => False);

   SourceUsed : SourcesUsed := NoSourceUsed;

   -- construct table of flags used to note when an error explanation of a particular
   -- kind, number and destination has been given.
   type PurposeArray is array (Error_Types.ConversionRequestSource) of Boolean;
   EmptyPurposeArray : constant PurposeArray := PurposeArray'(False, False, False, False);

   type ErrorNumberArray is array (Error_Types.ErrNumRange) of PurposeArray;
   EmptyErrorNumberArray : constant ErrorNumberArray := ErrorNumberArray'(Error_Types.ErrNumRange => EmptyPurposeArray);

   type ExplanationClasses is
     (FlowErrors, DependencyErrs, SemanticErrs, DepSemanticErrs, Warnings, Notes, ControlFlows, IneffectiveStatements);

   type ExplanationTables is array (ExplanationClasses) of ErrorNumberArray;
   EmptyExplanationTable : constant ExplanationTables :=
     ExplanationTables'(ExplanationClasses => EmptyErrorNumberArray);

   -- giving us the actual table (and refinement constituent)
   ExplanationTable : ExplanationTables := EmptyExplanationTable;

   --------------------------------------------------------------------------

   procedure ToString (ErrNum  : in     Error_Types.NumericError;
                       Purpose : in     Error_Types.ConversionRequestSource;
                       ErrStr  :    out Error_Types.StringError)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in out ExplanationTable;
   --#        in out SourceUsed;
   --# derives ErrStr           from CommandLineData.Content,
   --#                               Dictionary.Dict,
   --#                               ErrNum,
   --#                               ExplanationTable,
   --#                               LexTokenManager.StringTable,
   --#                               Purpose &
   --#         ExplanationTable from *,
   --#                               CommandLineData.Content,
   --#                               ErrNum,
   --#                               Purpose &
   --#         SourceUsed       from *,
   --#                               CommandLineData.Content,
   --#                               ErrNum;
   is separate;

   --------------------------------------------------------------------------

   procedure OutputReferenceList (ToFile : in SPARK_IO.File_Type)
   --# global in     CommandLineData.Content;
   --#        in     SourceUsed;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                SourceUsed,
   --#                                ToFile;
   is

      procedure OutputAReference (Source : in Sources;
                                  ToFile : in SPARK_IO.File_Type)
      --# global in     CommandLineData.Content;
      --#        in out SPARK_IO.File_Sys;
      --# derives SPARK_IO.File_Sys from *,
      --#                                CommandLineData.Content,
      --#                                Source,
      --#                                ToFile;
      is
      begin
         case Source is
            when LRM     =>
               if CommandLineData.IsSpark83 then
                  SPARK_IO.Put_Line
                     (ToFile,
                      "Ada LRM:     Ada Reference Manual (ANSI/MIL-STD-1815A-1983)",
                      0);
               else
                  SPARK_IO.Put_Line
                     (ToFile,
                      "Ada LRM:     Ada Reference Manual (ISO/IEC 8652:1995)",
                      0);
               end if;
            when SR83    =>
               SPARK_IO.Put_Line
                  (ToFile,
                   "SR:          SPARK - The SPADE Ada Kernel",
                   0);
            when SR95    =>
               SPARK_IO.Put_Line
                  (ToFile,
                   "SR:          SPARK95 - The SPADE Ada95 Kernel",
                   0);
            when UM      =>
               SPARK_IO.Put_Line
                  (ToFile,
                   "User Manual: SPARK Examiner User Manual",
                   0);
            when VCGUM   =>
               SPARK_IO.Put_Line
                  (ToFile,
                   "VCG Manual:  Generation of Verification Conditions for SPARK Programs",
                   0);
            when RTCUM   =>
               SPARK_IO.Put_Line
                  (ToFile,
                   "RTC Manual:  Generation of Run-time Checks for SPARK Programs",
                   0);
            when JB      =>
               SPARK_IO.Put_Line
                  (ToFile,
                   "Barnes:      High Integrity Software - The SPARK Approach",
                   0);
            when others  =>
               SPARK_IO.Put_Line (ToFile, "Unexpected reference table entry", 0);
         end case;
      end OutputAReference;

      ---------------------

   begin --OutputReferenceList
      for I in Sources range LRM .. Sources'Last loop
         if SourceUsed (I) then
            SPARK_IO.New_Line (ToFile, 2);
            SPARK_IO.Put_Line (ToFile, "References used:", 0);
            for J in Sources range LRM .. Sources'Last loop
               if SourceUsed (J) then
                  OutputAReference (J, ToFile);
               end if;
            end loop;
            exit;
         end if;
      end loop;
   end OutputReferenceList;

   -- state initialized at declaration

end Conversions;
