separate (ErrorHandler.Conversions.ToString.WarningWithPosition)
procedure WarningWithPositionExpl (EStr   : in out ELStrings.T)

is
   pragma Warnings (Off); -- Suppress warning for redundant others in case statement
begin
   case ErrNum.ErrorNum is
      when 1 =>
         ELStrings.AppendString
            (EStr, "This warning will appear against an identifier in a with clause if" &
              " it is not also present in an inherit clause. Such an identifier" &
              " cannot be used in any non-hidden part of" &
              " a SPARK program. The use of with without inherit is permitted to" &
              " allow reference in hidden" &
              " parts of the text to imported packages which are not legal SPARK." &
              " For example, the body of" &
              " SPARK_IO is hidden and implements the exported operations of the" &
              " package by use of package" &
              " TEXT_IO. For this reason TEXT_IO must appear in the with clause of" &
              " SPARK_IO. (warning control file keyword: with_clauses)");
      when 2 =>
         ELStrings.AppendString
            (EStr, "The significance of representation clauses cannot be assessed by the" &
              " Examiner because" &
              " it depends on the specific memory architecture of the target system." &
              " Like pragmas," &
              " representation clauses can change the meaning of a SPARK program and" &
              " the warning" &
              " highlights the need to ensure their correctness by other means." &
              " (warning control file" &
              " keyword: representation_clauses)");
      when 3 =>
         ELStrings.AppendString
            (EStr, "All pragmas encountered by the Examiner generate this warning." &
              " While many pragmas (e.g." &
              " pragma page) are harmless others can change a program's meaning," &
              " for example by causing" &
              " two variables to share a single memory location." &
              " (warning control file keyword: pragma" &
              " pragma_identifier or pragma all)");
      when 4 =>
         ELStrings.AppendString
            (EStr, "The declare annotation is ignored by the Examiner if the profile" &
              " is not Ravenscar. (warning control file keyword: declare_annotations)");
      when 5 =>
         ELStrings.AppendString
            (EStr, "Interrupt identifiers are implementation defined and the Examiner cannot check that values are" &
              " used only once.  Duplication can occur by declaring more than object of a single (sub)type where" &
              " that type defines handlers.  It may also occur if interrupt identifiers are set via discriminants" &
              " and two or more actual discriminants generate the same value." &
              " (warning control file keyword: interrupt_handlers)");
      when 6 =>
         ELStrings.AppendString
            (EStr, "Machine code is inherently implementation dependent and cannot be analysed" &
              " by the SPARK Examiner.  Users are responsible for ensuring that the behaviour" &
              " of the inserted machine code matches the annotation of the subprogram containing it.");
      when 7 =>
         ELStrings.AppendString
            (EStr, "Such identifiers will be rejected by an Ada2005 compiler or by the SPARK" &
              " Examiner when SPARK2005 is implemented. It is recommended to rename" &
              " such identifiers for future upward compatibility." &
              " (warning control file keyword: ada2005_reserved_words)");
      when 11 =>
         ELStrings.AppendString
            (EStr, "The others clause is non-executable because all case choices have" &
              " already been" &
              " covered explicitly.  If the range of the case choice is altered later" &
              " then the" &
              " others clause may be executed with unexpected results.  It is better" &
              " to omit the" &
              " others clause in which case any extension of the case range will result in a" &
              " compilation error.");
      when 12 =>
         ELStrings.AppendString
            (EStr, "See ALRM 13.9.  The use of Unchecked_Conversion can result in implementation-defined" &
              " values being returned.  The function should be used with great care.  The principal" &
              " use of Unchecked_Conversion is SPARK programs is the for the reading of external ports" &
              " prior to performing a validity check; here the suppression of constraint checking prior" &
              " to validation is useful.  The Examiner does not assume that the value returned by" &
              " an unchecked conversion is valid and so unprovable run-time check VCs will result if" &
              " a suitable validity check is not carried out before the value is used." &
              " (warning control file keyword: unchecked_conversion)");
      when 13 =>
         ELStrings.AppendString
            (EStr, "See ALRM 13.9.  The use of Unchecked_Conversion can result in invalid" &
              " values being returned.  The function should be used with great care especially, as in" &
              " this case, where the type returned does not generate Ada run-time checks nor SPARK" &
              " run-time verification conditions.  For such types, this warning is the ONLY reminder" &
              " the Examiner generates that the generated value may have an invalid representation." &
              " For this reason the warning is NOT suppressed by the warning control file keyword" &
              " unchecked_conversion." &
              " The principal use of Unchecked_Conversion is SPARK programs is the for the reading of external ports" &
              " prior to performing a validity check; here the suppression of constraint checking prior" &
              " to validation is useful.");
      when 120 =>
         ELStrings.AppendString
            (EStr, "This end accept annotation does not match any preceding start accept in this unit.");
      when 121 =>
         ELStrings.AppendString
            (EStr, "The accept annotation is used to indicate that a particular flow error or semantic warning" &
              " message is expected and can be justified.  This error indicates that the expected message" &
              " did not actually occur.  Note that when matching any information flow error messages containing" &
              " two variable names, the export should be placed first and the import second (the order" &
              " in the error message may differ from this depending on the style of information flow" &
              " error reporting selected).  For example: --# accept Flow, 601, X, Y, ""...""; justifies" &
              " the message: ""X may be derived from the imported value(s) of Y"" or the alternative" &
              " form: ""Y may be used in the derivation of X"".");
      when 122 =>
         ELStrings.AppendString
            (EStr, "The number of justifications per source file is limited.  If you reach this limit" &
              " it is worth careful consideration of why the code generates so many warnings.");
      when 169 =>
         ELStrings.AppendString
            (EStr, "With the publication of Edition 3.1 of the SPARK Definition the" &
              " previous restriction" &
              " prohibiting the direct updating of own variables of non-enclosing" &
              " packages was removed; however, the preferred use of packages as" &
              " abstract state machines is compromised by such action which is" &
              " therefore discouraged. (warning control file keyword: direct_updates)");
      when 200 =>
         ELStrings.AppendString
            (EStr, "Issued if a static expression exceeds the internal limits of the Examiner" &
              " because its" &
              " value is, for example, too large to be evaluated using infinite precision" &
              " arithmetic. No" &
              " value will be recorded for the expression and this may limit the" &
              " Examiner's ability to" &
              " detect certain sorts of errors such as numeric constraints." &
              " (warning control file keyword: static_expressions)");
      when 201 =>
         ELStrings.AppendString
            (EStr, "Raised, for example, when evaluating 'Size of a type" &
              " that does not have an explicit Size representation clause." &
              " Attributes of implementation-defined types, such as" &
              " Integer'Last may also be" &
              " unknown to be Examiner if they are not specified in the" &
              " configuration fil" &
              " (warning control file keyword: static_expressions)");
      when 202 =>
         ELStrings.AppendString
            (EStr, "Raised when comparing two real numbers. The examiner cannot deal" &
              " with real numbers specified to" &
              " such a high degree of precision. Consider reducing the precision" &
              " of these numbers.");
      when 300 =>
         ELStrings.AppendString
            (EStr, "Issued when an aggregate of a multi-dimensional array is found." &
              " Suppresses generation" &
              " of VCs or PFs for that subprogram. Can be worked round by using" &
              " arrays of arrays.");
      when 302 =>
         ELStrings.AppendString
            (EStr, "Issued when a potentially re-orderable expression is encountered." &
              " For example x := a + b + c; Whether" &
              " intermediate sub-expression values overflow may depend on the" &
              " order of evaluation which is" &
              " compiler-dependent." &
              " Therefore, code generating this warning should be parenthesized to" &
              " remove the ambiguity." &
              " e.g. x := (a + b) + c;");
      when 303 =>
         ELStrings.AppendString
            (EStr, "Issued where choices in an array aggregate or case statement are" &
              " outside the range" &
              " which can be detected because of limits on the size of a table" &
              " internal to the Examiner.");
      when 304 =>
         ELStrings.AppendString
            (EStr, "Issued when the Examiner cannot determine the completeness of a" &
              " case statement because" &
              " the bounds of the type of the controlling expression exceed the" &
              " size of the internal table" &
              " used to perform the checks.");
      when 305 =>
         ELStrings.AppendString
            (EStr, "Issued when the Examiner cannot determine the completeness of an" &
              " array aggregate or" &
              " case statement because the number used in a choice exceed the size" &
              " allowed in the internal" &
              " table used to perform the checks.");
      when 306 =>
         ELStrings.AppendString
            (EStr, "Issued when the Examiner cannot determine the completeness of an" &
              " array aggregate" &
              " because its bounds exceed the size of the internal table used to" &
              " perform the checks.");
      when 307 =>
         ELStrings.AppendString
            (EStr, "Issued where the array index (sub)type is inappropriate: this is" &
              " probably because there" &
              " is an error in its definition, which will have been indicated by" &
              " a previous error message.");
      when 308 =>
         ELStrings.AppendString
            (EStr, "The use of this operator is discouraged in SPARK because of the" &
              " difficulty in" &
              " determining exactly what it means to say that two instances of a" &
              " floating point number are" &
              " equal");
      when 309 =>
         ELStrings.AppendString
            (EStr, "Issued where a type conversion is either converting from a (sub)type" &
              " to the same" &
              " (sub)type or is converting between two subtypes of the same type." &
              " In the former case the" &
              " type conversion may be safely removed because no constraint check" &
              " is required; in the" &
              " latter case the type conversion may be safely replaced by a type" &
              " qualification which" &
              " preserves the constraint check.(warning control file keyword:" &
              " type_conversions)");
      when 310 =>
         ELStrings.AppendString
            (EStr, "Issued when a language feature defined by Ada 95 to be obsolescent is" &
              " used.  Use of such" &
              " features is not recommended because compiler support for them cannot" &
              " be guaranteed.(warning control file keyword:obsolescent_features)");
      when 312 =>
         ELStrings.AppendString
            (EStr, "Issued when a VC or PF references a multi-dimensional array constant." &
              " Can be worked round by using arrays of arrays.");
      when 313 =>
         ELStrings.AppendString
            (EStr, "Issued when replacement rules are requested for a composite constant which" &
              " had semantic errors in its initializing expression, or is" &
              " a deferred constant whose completion is hidden from the Examiner." &
              " Semantic errors must be eliminated before replacement rules can be generated.");
      when 314 =>
         ELStrings.AppendString
            (EStr, "Issued when an attempt is made to generate type deduction rules for a constant" &
              " which has semantic errors in its type.  These semantic errors" &
              " must be eliminated before type deduction rules can be generated.");
      when 350 =>
         ELStrings.AppendString
            (EStr, "The presence of a pragma Import makes it possible that the variable" &
              " is connected" &
              " to some external device.  The behaviour of such variables is best" &
              " captured by" &
              " making them moded own variables (or ""stream"" variables).  If variables" &
              " connected" &
              " to the external environment are treated as if they are normal program" &
              " variables then" &
              " misleading analysis results are inevitable.  The use of pragma Import on local" &
              " variables of subprograms is particularly deprecated. The warning" &
              " may safely be" &
              " disregarded if the variable is not associated with memory-mapped" &
              " input/output" &
              " or if the variable concerned is an own variable and the operations on it are" &
              " suitably annotated to indicate volatile, stream-like behaviour." &
              " Where pragma Import is used, it is essential that the variable is properly" &
              " initialized at the point from which it is imported." &
              " (warning control file keyword:imported_objects)");
      when 351 =>
         ELStrings.AppendString
            (EStr, "Great care is needed when attaching an address clause to a constant.  The use" &
              " of such a clause is safe if, and only if, the address supplied provides a valid" &
              " value for the constant which does not vary during the execution life of the program," &
              " for example, mapping the constant to PROM data." &
              " If the address clause causes the constant to have a value which may alter, or worse," &
              " change dynamically under the influence of some device external to the program, then" &
              " misleading or incorrect analysis is certain to result." &
              " If the intention is to create an input port of some kind, then a constant should not" &
              " be used.  Instead a moded own variable (or ""stream"" variables) should be used." &
              " (warning control file keyword: address_clauses)");
      when 390 =>
         ELStrings.AppendString
            (EStr, "Issued to inform the user that a generic subprogram instantiation" &
              " cannot be completed because of earlier errors in the generic declaration.");
      when 392 =>
         ELStrings.AppendString
            (EStr, "Where values are read from external variables (i.e. variables" &
              " connected to the external" &
              " environment) there is no guarantee that the bit pattern read will" &
              " be a valid representation for" &
              " the type of the external variable.  Unexpected behaviour may result" &
              " if invalid values are used in expressions." &
              " If the code is compiled with Ada run-time checks enabled the" &
              " assignment of an invalid value may (but need not) raise a" &
              " run-time exception dependent on the compiler." &
              " A compiler may provide facilities to apply extended checking" &
              " which may also raise a run-time exception if an invalid value is used." &
              " The SPARK Toolset does not check the validity of the external variable" &
              " and therefore any possible exception arising from its assignment is" &
              " outside the scope of proof of absence of RTE." &
              " To ensure that a run-time exception cannot occur make the type of" &
              " the external variable such that any possible bit pattern that" &
              " may be read from the external source is a valid value." &
              " If the desired type is such a type then the always_valid assertion" &
              " may be applied to the external variable; otherwise use explicit tests" &
              " to ensure it has a valid value for the desired type before converting" &
              " to an object of the desired type." &
              " In SPARK 95 the 'Valid attribute (see ALRM 13.9.2) may be used to" &
              " determine the validity of a value if it can be guaranteed that the" &
              " assignment of an invalid value read from an external variable will" &
              " not raise a run time exception, either by compiling the code with" &
              " checks off or by ensuring the compiler does not apply constraint" &
              " checks when assigning same subtype objects." &
              " Note that when the Examiner is used to generate run-time checks, it" &
              " will not be possible to discharge those involving external variables" &
              " unless one of the above steps is taken." &
              " More information on interfacing can be found in the INFORMED manual" &
              " and the Generation of RTCs for SPARK Programs manual." &
              " (warning control file" &
              " keyword: external_assignment)");
      when 393 =>
         ELStrings.AppendString
            (EStr, "Where values are read from external variables (i.e. variables" &
              " connected to the external" &
              " environment) there is no guarantee that the bit pattern read will" &
              " be a valid representation for" &
              " the type of the external variable.  Unexpected behaviour may result" &
              " if invalid values are used in expressions." &
              " If the code is compiled with Ada run-time checks enabled the" &
              " assignment of an invalid value may (but need not) raise a" &
              " run-time exception dependent on the compiler." &
              " A compiler may provide facilities to apply extended checking" &
              " which may also raise a run-time exception if an invalid value is used" &
              " The SPARK Toolset does not check the validity of the external variable" &
              " and therefore any possible exception arising from its assignment is" &
              " outside the scope of proof of absence of RTE." &
              " Where, as in this case, the type is one for which" &
              " Ada run-time checks need not be generated and SPARK run-time" &
              " verification conditions are not generated, extra care is required." &
              " For such types, this warning is the ONLY reminder" &
              " the Examiner generates that the external value may have an invalid" &
              " representation." &
              " For this reason the warning is NOT suppressed by the warning" &
              " control file keyword  external_assignment." &
              " To ensure that a run-time exception cannot occur make the type of" &
              " the external variable such that any possible bit pattern that" &
              " may be read from the external source is a valid value." &
              " Explicit tests of the value may then be used to determine the" &
              " value of an object of the desired type." &
              " In SPARK 95 the 'Valid attribute (see ALRM 13.9.2) may be used to" &
              " determine the validity of a value if it can be guaranteed that the" &
              " assignment of an invalid value read from an external variable will" &
              " not raise a run time exception, either by compiling the code with" &
              " checks off or by ensuring the compiler does not apply constraint" &
              " checks when assigning same subtype objects." &
              " Boolean external variables require special care since the Examiner" &
              " does not generate run-time checks" &
              " for Boolean variables; use of 'Valid is essential when reading" &
              " Boolean external variables." &
              " More information on interfacing can be found in the INFORMED manual" &
              " and the Generation of RTCs for SPARK Programs manual.");
      when 394 =>
         ELStrings.AppendString
            (EStr, "A variable of a private type can only be used (without generating" &
              " a data flow error) if there is some way of" &
              " giving it an initial value.  For a limited private type only a" &
              " procedure that has an export of that type" &
              " and no imports of that type is suitable.  For a private type either" &
              " a procedure, function or (deferred)" &
              " constant is required.  The required facility may be placed in, or" &
              " already available in, a public" &
              " child package." &
              " (warning control file keyword: private_types)");
      when 395 =>
         ELStrings.AppendString
            (EStr, "When own variables are given modes they are considered to be inputs" &
              " from or outputs" &
              " to the external environment.  The Examiner regards them as being" &
              " volatile (i.e. their" &
              " values can change in ways not visible from an inspection of the" &
              " source code).  If" &
              " a variable is declared in that way but it is actually an ordinary" &
              " variable which is NOT" &
              " connected to the environment then misleading analysis is inevitable." &
              " The Examiner" &
              " expects to find an address clause or pragma import for variables of this kind to" &
              " indicate that they" &
              " are indeed memory-mapped input/output ports.  This warning is issued" &
              " if an address" &
              " clause or pragma import is not found.");
      when 396 =>
         ELStrings.AppendString
            (EStr, "The presence of an address clause makes it possible that the variable" &
              " is connected" &
              " to some external device.  The behaviour of such variables is best" &
              " captured by" &
              " making them moded own variables (or ""stream"" variables).  If variables" &
              " connected" &
              " to the external environment are treated as if they are normal program" &
              " variables then" &
              " misleading analysis results are inevitable.  The use of address clauses" &
              " on local" &
              " variables of subprograms is particularly deprecated. The warning" &
              " may safely be" &
              " disregarded if the variable is not associated with memory-mapped" &
              " input/output" &
              " or if the variable concerned is an own variable and the operations on it are" &
              " suitably annotated to indicate volatile, stream-like behaviour." &
              " (warning control file keyword: address_clauses)");
      when 397 =>
         ELStrings.AppendString
            (EStr, "A variable of a private type can only be used (without generating a data" &
              " flow error) if there is some way of" &
              " giving it an initial value.  For a limited private type only a procedure" &
              " that has an export of that type" &
              " and no imports of that type is suitable.  For a private type either a" &
              " procedure, function or (deferred)" &
              " constant is required.");
      when 398 =>
         ELStrings.AppendString
            (EStr, "The own variable can only be used (without generating a data flow error)" &
              " if there is some way of" &
              " giving it an initial value.  If it is" &
              " initialized during package elaboration (or implicitly by the environment" &
              " because it represents an" &
              " input port) it should be placed in an ""initializes"" annotation." &
              " Otherwise there needs to be some way" &
              " of assigning an initial value during program execution.  Either the own" &
              " variable needs to be declared" &
              " in the visible part of the package so that a direct assignment can be" &
              " made to it or, more usually, the" &
              " package must declare at least one procedure for which the own variable" &
              " is an export but not an import." &
              " Note that if the own variable is an abstract own variable with some" &
              " constituents initialized" &
              " during elaboration and some during program execution then it will never" &
              " be possible correctly to" &
              " initialize it; such abstract own variables must be divided into separate" &
              " initialized and uninitialized" &
              " components.");
      when 399 =>
         ELStrings.AppendString
            (EStr, "Issued to inform the user that flow analysis has been suppressed" &
              " because of the error in the called subprogram's interface.");
      when others => null;
   end case;
end WarningWithPositionExpl;
