separate (ErrorHandler.Conversions.ToString.WarningWithoutPosition)
procedure WarningWithoutPositionExpl (EStr   : in out ELStrings.T)

is
   pragma Warnings (Off); -- Suppress warning for redundant others in case statement
begin
   case ErrNum.ErrorNum is
      when 9 =>
         ELStrings.AppendString
            (EStr, "Issued when a --# hide XXX annotation is used to hide a user-defined exception handler.  (warning control file keyword: handler_parts)");
      when 10 =>
         ELStrings.AppendString
            (EStr, "Issued when a --# hide XXX annotation is used.  (warning control file keyword: hidden_parts)");
      when 400 =>
         ELStrings.AppendString
            (EStr, "Issued when a variable declared in a subprogram is neither" &
              " referenced, nor updated." &
              " (warning control file keyword: unused_variables)");
      when 401 =>
         ELStrings.AppendString
            (EStr, "The SPARK Examiner does not, by default, generate run-time checks" &
              " for real numbers," &
              " due to the imprecise nature of their machine representations." &
              " Facilities are available for run-time checking of real numbers: please" &
              " seek advice if this is of interest.");
      when 402 =>
         ELStrings.AppendString
            (EStr, "In order to prove properties of code containing loops, the" &
              " loop must be ""cut"" with" &
              " a suitable assertion statement.  When generating run-time checks," &
              " the Examiner" &
              " inserts a simple assertion to cut any loops which do not have one" &
              " supplied" &
              " by the user.  The assertion is placed at the point where this" &
              " warning appears in" &
              " the listing file.  The default assertion asserts that the" &
              " subprogram's precondition" &
              " (if any) is satisfied, that all imports to it are in their" &
              " subtypes and that any for" &
              " loop counter is in its subtype.  In many cases this provides" &
              " sufficient information" &
              " to complete a proof of absence of run-time errors.  If more" &
              " information is required," &
              " then the user can supply an assertion and the Examiner will" &
              " append the above information" &
              " to it. (warning control file keyword: default_loop_assertions)");
      when 403 =>
         ELStrings.AppendString
            (EStr, "XXX is a variable which was initialized at declaration but" &
              " whose value is only ever" &
              " read not updated; it could therefore have been declared as" &
              " a constant. (warning control" &
              " file keyword: constant_variables)");
      when 405 =>
         ELStrings.AppendString
            (EStr, "Where the optional RealRTC switch is used, the Examiner" &
              " generates checks associated with" &
              " real numbers using perfect arithmetic rather than the machine" &
              " approximations used on the" &
              " target platform.  It is possible that rounding errors might" &
              " cause a constraint_error even" &
              " if these run-time check proofs are completed satisfactorily." &
              " Please consult the Supplementary" &
              " Release Note ""The RealRTC Option"" for more details." &
              " (warning control file keyword: real_rtcs)");
      when 406 =>
         ELStrings.AppendString
            (EStr, "This message is echoed to the screen if the Examiner is unable" &
              " to create output files for the VCs or PFs being generated" &
              " (for instance, if the user does not have write" &
              " permission for the output directory).");
      when 407 =>
         ELStrings.AppendString
            (EStr, "Issued where SPARK own variable and initialization annotations" &
              " make it clear that a" &
              " package requires a body but where no Ada requirement for a body" &
              " exists.");
      when 408 =>
         ELStrings.AppendString
            (EStr, "Semantic errors prevent VC Generation, so a single False VC" &
              " is produced. This will be detected and reported by POGS.");
      when 409 =>
         ELStrings.AppendString
            (EStr, "A subprogram which has excessive complexity of data structure" &
              " or number of paths may cause the VC Generator to exceed its capacity." &
              " A single False VC is generated in this case to make sure this" &
              " error is detected in subsequent proof and analysis with POGS");
      when 410 =>
         ELStrings.AppendString
            (EStr, "Partition-wide flow analysis is performed by checking all" &
              " packages withed by the main program for" &
              " tasks and interrupt handlers and constructing an overall flow" &
              " relation that captures their cumulative" &
              " effect.  It is for this reason that SPARK requires task and" &
              " protected types to be declared in package" &
              " specifications.  If a task or protected type which contains" &
              " an interrupt handler, is hidden from the" &
              " Examiner (in a hidden package private part) or contains errors" &
              " in it specification, the partition-wide" &
              " flow analysis cannot be" &
              " constructed correctly and is therefore suppressed.  Correct the" &
              " specification of the affected tasks" &
              " and (temporarily if desired) make them visible to the Examiner.");
      when 411 =>
         ELStrings.AppendString
            (EStr, "The Examiner checks that there is no potential sharing of" &
              " unprotected data between tasks.  If a task type" &
              " is hidden from the Examiner in a hidden package private" &
              " part, then it is not possible to check whether that" &
              " task may share unprotected data.");
      when 412 =>
         ELStrings.AppendString
            (EStr, "The Examiner checks that no more than one task can suspend on" &
              " a single object.  If a task" &
              " is hidden from the Examiner in a hidden package private part," &
              " then it is not possible to check whether that" &
              " task may suspend on the same object as another task.");
      when 413 =>
         ELStrings.AppendString
            (EStr, "The Examiner checks that no more than one task can suspend on a" &
              " single object and that there is no" &
              " potential sharing of unprotected data between tasks.  These checks" &
              " depend on the accuracy of the annotations" &
              " on the task types withed by the main program.  If these annotations" &
              " contain errors, then any reported" &
              " violations of the shared variable and max-one-in-a-queue checks will" &
              " be correct; however, the check" &
              " may be incomplete.  The errors in the task annotations should be corrected.");
      when 414 =>
         ELStrings.AppendString
            (EStr, "Raised if an output file name is longer than the" &
              " limit imposed by the operating system and has been truncated." &
              " Section 4.7 of the Examiner User Manual describes how the output file names" &
              " are constructed. If this message is seen there is a possibility" &
              " that the output from two" &
              " or more subprograms will be written to the same file name," &
              " if they have a sufficiently large number of characters in common.");
      when 420 =>
         ELStrings.AppendString
            (EStr, "In release 7.5 of the SPARK Examiner, a flaw in the VC generation" &
              " was fixed such that subcomponents of records and elements of" &
              " arrays when used as ""out"" or ""in out""" &
              " parameters will now generate an" &
              " additional VC to verify absence of run-time errors. This warning" &
              " flags an instance of this occurrence. Please read the release" &
              " note and/or seek advice for assistance with this issue.");
      when others => null;
   end case;
end WarningWithoutPositionExpl;
