-- $Id: errorhandler-conversions-tostring-noerr.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler.Conversions.ToString)
procedure NoErr (ErrNum : in     Error_Types.NumericError;
                 EStr   : in out ELStrings.T)
is
begin
   ELStrings.AppendString (EStr, "Flow analysis of");
   if ErrNum.Name1 = Error_Types.NoName then
      ELStrings.AppendString (EStr, " package initialization");
   elsif ErrNum.Name1 = Error_Types.ThePartitionName then
      ELStrings.AppendString (EStr, " the entire partition");
   else
      ELStrings.AppendString (EStr, " subprogram ");
      AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
   end if;
   ELStrings.AppendString (EStr, " performed: no errors found");
   ELStrings.AppendString (EStr, ".");
end NoErr;
