-- $Id: errorhandler-conversions-tostring-ineffectivestatement.adb 12530 2009-02-20 09:43:11Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler.Conversions.ToString)
procedure IneffectiveStatement (ErrNum          : in     Error_Types.NumericError;
                                WithExplanation : in     Boolean;
                                EStr            : in out ELStrings.T)
is
   procedure IneffectiveStatementExpl (EStr   : in out ELStrings.T)
   --# global in ErrNum;
   --# derives EStr from *,
   --#                   ErrNum;
      is separate;
   -- Note that the parameter names for this subunit are chosen to make it as easy as
   --      possible to auto-generate the subunit from this, its parent, file.  The
   --      generation requires copying the case statement below, stripping out the
   --      current Append'Thing' statements and adding an AppendString for the
   --      explanatory text that is delineated by --! comments.

   procedure AppendExplanation
   --# global in     ErrNum;
   --#        in     WithExplanation;
   --#        in out EStr;
   --# derives EStr from *,
   --#                   ErrNum,
   --#                   WithExplanation;
   is
      ExplanationString : ELStrings.T := ELStrings.EmptyString;
   begin
      if WithExplanation then
         -- we need to at least look for an explanation
         IneffectiveStatementExpl (ExplanationString);
         if ExplanationString.Length > 0 then
            -- there actually is one
            ELStrings.AppendString (EStr, ErrorHandler.ExplanationPrefix);
            ELStrings.AppendExaminerLongString (EStr, ExplanationString);
            ELStrings.AppendString (EStr, ErrorHandler.ExplanationPostfix);
         end if;
      end if;
   end AppendExplanation;

begin

   -- HTML Directives
   --! <NameFormat> <"flow-"><Name>
   --! <ErrorFormat> <"!!! Flow Error : "><Name><" : "><Error>

   if ErrNum.Name1 = Error_Types.NoName then
      --! <Name> 10
      ELStrings.AppendString (EStr, "Ineffective statement");
      --! Execution of this statement cannot affect the final value of any exported
      --! variable of the subprogram in which it occurs. The cause may be a
      --! data-flow anomaly (i.e. the statement could be an assignment to a
      --! variable, which is always updated again before it is read. However,
      --! statements may be ineffective for other reasons - see Section 4.1 of
      --! Appendix A.
   else
      --! <Name> 10
      ELStrings.AppendString (EStr, "Assignment to ");
      AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
      ELStrings.AppendString (EStr, " is ineffective");
      --! This message always relates to a procedure call or an assignment to a
      --! record. The variable XXX may be an actual parameter corresponding to a
      --! formal one that is exported;
      --! otherwise XXX is an exported global variable of the procedure.
      --! The message indicates that
      --! the updating of XXX, as a result of the procedure call, has no effect on
      --! any final values of exported variables of the calling subprogram.
      --! Where the ineffective assignment is expected (e.g. calling a supplied
      --! procedure that returns more parameters than are needed for the immediate purpose),
      --! it can be a useful convention to choose a distinctive name, such as &quot;Unused&quot; for
      --! the actual parameter concerned.  The message &quot;Assignment to Unused is ineffective&quot;
      --! is then self-documenting.
   end if;
   AppendExplanation;
   ELStrings.AppendString (EStr, ".");
end IneffectiveStatement;
