-- $Id: errorhandler-conversions-tostring-controlflowerror.adb 12530 2009-02-20 09:43:11Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler.Conversions.ToString)
procedure ControlFlowError (ErrNum          : in     Error_Types.NumericError;
                            WithExplanation : in     Boolean;
                            EStr            : in out ELStrings.T)
is
   ErrType : ErrorHandler.ControlFlowErrType;

   procedure ControlFlowErrorExpl (EStr   : in out ELStrings.T)
   --# global in ErrType;
   --# derives EStr from *,
   --#                   ErrType;
      is separate;
   -- Note that the parameter names for this subunit are chosen to make it as easy as
   --      possible to auto-generate the subunit from this, its parent, file.  The
   --      generation requires copying the case statement below, stripping out the
   --      current Append'Thing' statements and adding an AppendString for the
   --      explanatory text that is delineated by --! comments.

   procedure AppendExplanation
   --# global in     ErrType;
   --#        in     WithExplanation;
   --#        in out EStr;
   --# derives EStr from *,
   --#                   ErrType,
   --#                   WithExplanation;
   is
      ExplanationString : ELStrings.T := ELStrings.EmptyString;
   begin
      if WithExplanation then
         -- we need to at least look for an explanation
         ControlFlowErrorExpl (ExplanationString);
         if ExplanationString.Length > 0 then
            -- there actually is one
            ELStrings.AppendString (EStr, ErrorHandler.ExplanationPrefix);
            ELStrings.AppendExaminerLongString (EStr, ExplanationString);
            ELStrings.AppendString (EStr, ErrorHandler.ExplanationPostfix);
         end if;
      end if;
   end AppendExplanation;

begin
   ErrType := ErrorHandler.ControlFlowErrType'Val (ErrNum.ErrorNum -
                                                   Error_Types.ControlFlowErrOffset);
   case ErrType is

      -- HTML Directives
      --! <NameFormat> <"illegal-"><Name>
      --! <ErrorFormat> <"*** Illegal Structure : "><Name><" : "><Error>

      when ErrorHandler.MisplacedExit =>
         --! <Name> 1
         ELStrings.AppendString
            (EStr,
             "An exit statement may not occur here");
         --! Exit statements must be of the form &quot;exit when c;&quot; where the closest
         --! enclosing statement is a loop or &quot;if c then S; exit;&quot; where the
         --! if statement has no else part and its closest enclosing
         --! statement is a loop.  See the SPARK Definition for details.

      when ErrorHandler.MisplacedReturn =>
         --! <Name> 2
         ELStrings.AppendString
            (EStr,
             "A return statement may not occur here");
         --! A return statement may only occur as the last statement of a function.

      when ErrorHandler.MissingReturn =>
         --! <Name> 3
         ELStrings.AppendString
            (EStr,
             "The last statement of this function is not a return statement");
         --! SPARK requires that the last statement of a function be a return statement.

      when ErrorHandler.ReturnInProc =>
         --! <Name> 4
         ELStrings.AppendString
            (EStr,
             "Return statements may not occur in procedure subprograms");
   end case;
   AppendExplanation;
   ELStrings.AppendString (EStr, ".");
end ControlFlowError;
