separate (ErrorHandler.Conversions.ToString.ControlFlowError)
procedure ControlFlowErrorExpl (EStr   : in out ELStrings.T)

is
   pragma Warnings (Off); -- Suppress warning for redundant others in case statement
begin
   case ErrType is
      when ErrorHandler.MisplacedExit =>
         ELStrings.AppendString
            (EStr, "Exit statements must be of the form ""exit when c;"" where the closest" &
              " enclosing statement is a loop or ""if c then S; exit;"" where the" &
              " if statement has no else part and its closest enclosing" &
              " statement is a loop.  See the SPARK Definition for details.");
      when ErrorHandler.MisplacedReturn =>
         ELStrings.AppendString
            (EStr, "A return statement may only occur as the last statement of a function.");
      when ErrorHandler.MissingReturn =>
         ELStrings.AppendString
            (EStr, "SPARK requires that the last statement of a function be a return statement.");
      when others => null;
   end case;
end ControlFlowErrorExpl;
