-- $Id: errorhandler-conversions-tostring-appendreference.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler.Conversions.ToString)
procedure AppendReference (EStr      : in out ELStrings.T;
                           Reference : in     Natural)
is
   subtype Index12 is Positive range 1 .. 12;
   subtype Paras  is String (Index12);

   type References is record
      Source       : Sources;
      Para         : Paras;
   end record;

   --e.g. ALRM 12.3.4(6) == References'(LRM, Paras'("12.3.4(6)   "));

   EmptyReference : constant References := References'(Nul,
                                                       Paras'("            "));

   MaxReferences : constant Positive := 22;  --INCREMENT WHEN ADDING REFS
   subtype ReferenceIndexes is Positive range 1 .. MaxReferences;
   type Variants is (Spark83, Spark95);
   type ReferenceTables is array (ReferenceIndexes, Variants) of References;

   -- References arranged thus:
   --
   -- RefNo => (Spark83-ref,
   --           Spark95-ref)

   ReferenceTable : constant ReferenceTables := ReferenceTables'
      (1   => (Spark83  => References'(LRM, Paras'("4.9         ")),
               Spark95  => EmptyReference),
       2   => (Spark83  => References'(LRM, Paras'("3.3.3(9)    ")),
               Spark95  => EmptyReference),
       3   => (Spark83  => References'(LRM, Paras'("3.6.1(3)    ")),
               Spark95  => EmptyReference),
       4   => (Spark83  => EmptyReference,
               Spark95  => References'(LRM,   Paras'("7.2(4)      "))),
       5   => (Spark83  => References'(SR83,  Paras'("5.2.1       ")),
               Spark95  => References'(SR95,  Paras'("5.2.1       "))),
       6   => (Spark83  => References'(SR83,  Paras'("3.6.3       ")),
               Spark95  => References'(SR95,  Paras'("3.6.3       "))),
       7   => (Spark83  => References'(SR83,  Paras'("4.1         ")),
               Spark95  => References'(SR95,  Paras'("4.1         "))),
       8   => (Spark83  => References'(LRM, Paras'("5.2(3)      ")),
               Spark95  => References'(LRM, Paras'("5.2(4)      "))),
       9   => (Spark83  => EmptyReference,
               Spark95  => References'(LRM, Paras'("J.3         "))),
       10  => (Spark83  => References'(LRM, Paras'("3.2.2(1)    ")),
               Spark95  => References'(LRM, Paras'("3.3.2(3)    "))),
       11  => (Spark83  => References'(LRM, Paras'("6.3.1(5)    ")),
               Spark95  => References'(LRM, Paras'("6.3.1(18)   "))),
       12  => (Spark83  => References'(LRM, Paras'("7.4(4)      ")),
               Spark95  => EmptyReference),
       13  => (Spark83  => References'(SR83,  Paras'("3.2(Note2)  ")),
               Spark95  => References'(SR95,  Paras'("3.2(Note2)  "))),
       14  => (Spark83  => References'(LRM, Paras'("5.2(2)      ")),
               Spark95  => References'(LRM, Paras'("5.2(2)      "))),
       15  => (Spark83  => References'(SR83,  Paras'("3.3.2       ")),
               Spark95  => References'(SR95,  Paras'("3.3.2       "))),
       16  => (Spark83  => References'(SR83,  Paras'("7.3.1       ")),
               Spark95  => References'(SR95,  Paras'("7.3.1       "))),
       17  => (Spark83  => References'(LRM, Paras'("10.2(3)     ")),
               Spark95  => References'(LRM, Paras'("10.1.3(13)  "))),
       18  => (Spark83  => References'(SR83,  Paras'("3.9(1)      ")),
               Spark95  => References'(SR95,  Paras'("3.9(1)      "))),
       19  => (Spark83  => References'(SR83,  Paras'("6.3         ")),
               Spark95  => References'(SR95,  Paras'("6.3         "))),
       20  => (Spark83  => References'(SR83,  Paras'("7.2.3       ")),
               Spark95  => References'(SR95,  Paras'("7.2.3       "))),
       21  => (Spark83  => References'(LRM, Paras'("6.3(3)      ")),
               Spark95  => References'(LRM, Paras'("6.1(20)     "))),
       22  => (Spark83  => References'(LRM, Paras'("4.6(3)      ")),
               Spark95  => References'(LRM, Paras'("4.6(61)     ")))
       );


   CurrentReference : References;

   --------------------------------------

   function GetVariant return Variants
      --# global in CommandLineData.Content;
   is
      Result : Variants;
   begin
      if CommandLineData.IsSpark83 then
         Result := Spark83;
      else
         Result := Spark95;
      end if;
      return Result;
   end GetVariant;

   --------------------------------------

   procedure AppendSource (EStr   : in out ELStrings.T;
                           Source : in     Sources)
      --# derives EStr from *,
      --#                   Source;
   is
   begin
      case Source is
         when Nul     => null;
         when LRM     => ELStrings.AppendString (EStr, "Ada LRM ");
         when SR83    => ELStrings.AppendString (EStr, "SR83 ");
         when SR95    => ELStrings.AppendString (EStr, "SR95 ");
         when UM      => ELStrings.AppendString (EStr, "User Manual ");
         when VCGUM   => ELStrings.AppendString (EStr, "VCG Manual ");
         when RTCUM   => ELStrings.AppendString (EStr, "RTC Manual");
         when JB      => ELStrings.AppendString (EStr, "Barnes ");
      end case;
   end AppendSource;

   --------------------------------------

   procedure AppendPara (EStr   : in out ELStrings.T;
                         Para   : in     Paras)
      --# derives EStr from *,
      --#                   Para;
   is
      Ok : Boolean;
   begin
      for I in Index12 loop
         exit when Para (I) = ' ';
         ELStrings.AppendChar (EStr,
                                         Para (I),
                                         Ok);
         exit when not Ok;
      end loop;
   end AppendPara;

   --------------------------------------

begin --AppendReference
   if Reference /= ErrorHandler.NoReference and
      not CommandLineData.Content.PlainOutput then

      if Reference > MaxReferences then
         ELStrings.AppendString (EStr, " [Ref No Too High]");
      else
         CurrentReference := ReferenceTable (Reference, GetVariant);
         if CurrentReference /= EmptyReference then
            SourceUsed (CurrentReference.Source) := True;
            ELStrings.AppendString (EStr, " [");
            AppendSource (EStr, CurrentReference.Source);
            AppendPara (EStr, CurrentReference.Para);
            ELStrings.AppendString (EStr, "]");
         end if;
      end if;
   end if;
end AppendReference;
