-- $Id: errorhandler-appendsym.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler)
procedure AppendSym (Error : in out Error_Types.StringError;
                     Sym   : in     SPSymbols.SPSymbol)
is
   --# hide AppendSym;

   procedure AppendReservedWord (S : String)
   --# global in out Error;
   --# derives Error from *,
   --#                    S;
   is
   begin
      AppendString (Error, S (S'First + 2 .. S'Last));
   end AppendReservedWord;

   ------------------------------------------

begin --AppendSym
   case Sym is
      when SPSymbols.RWabort .. SPSymbols.RWxor =>
         AppendString (Error, "reserved word """);
         AppendReservedWord (SPSymbols.SPSymbol'Image (Sym));
         AppendString (Error, """");
      when SPSymbols.ampersand =>
         AppendString (Error, """&""");
      when SPSymbols.apostrophe =>
         AppendString (Error, """'""");
      when SPSymbols.left_paren =>
         AppendString (Error, """(""");
      when SPSymbols.right_paren =>
         AppendString (Error, """)""");
      when SPSymbols.multiply =>
         AppendString (Error, """*""");
      when SPSymbols.plus =>
         AppendString (Error, """+""");
      when SPSymbols.comma =>
         AppendString (Error, """,""");
      when SPSymbols.minus =>
         AppendString (Error, """-""");
      when SPSymbols.point =>
         AppendString (Error, """.""");
      when SPSymbols.divide =>
         AppendString (Error, """/""");
      when SPSymbols.colon =>
         AppendString (Error, """:""");
      when SPSymbols.semicolon =>
         AppendString (Error, """;""");
      when SPSymbols.less_than =>
         AppendString (Error, """<""");
      when SPSymbols.equals =>
         AppendString (Error, """=""");
      when SPSymbols.greater_than =>
         AppendString (Error, """>""");
      when SPSymbols.vertical_bar =>
         AppendString (Error, """|""");
      when SPSymbols.tilde =>
         AppendString (Error, """~""");
      when SPSymbols.arrow =>
         AppendString (Error, """=>""");
      when SPSymbols.double_dot =>
         AppendString (Error, """..""");
      when SPSymbols.double_star =>
         AppendString (Error, """**""");
      when SPSymbols.becomes =>
         AppendString (Error, """:=""");
      when SPSymbols.not_equal =>
         AppendString (Error, """/=""");
      when SPSymbols.greater_or_equal =>
         AppendString (Error, """>=""");
      when SPSymbols.less_or_equal =>
         AppendString (Error, """<=""");
      when SPSymbols.box =>
         AppendString (Error, """<>""");
      when SPSymbols.implies =>
         AppendString (Error, """->""");
      when SPSymbols.is_equivalent_to =>
         AppendString (Error, """<->""");
      when SPSymbols.square_open =>
         AppendString (Error, """[""");
      when SPSymbols.square_close =>
         AppendString (Error, """]""");
      when others =>
         AppendString (Error, SPSymbols.SPSymbol'Image (Sym));
   end case;
end AppendSym;
