-- $Id: dictionary-writereference.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure WriteReference (Discriminant    : in ReferenceDiscriminant;
                          Item            : in Symbol;
                          CompilationUnit : in Symbol;
                          Reference       : in Location)
is

   --------------------------------------------------------------------------------

   procedure WriteDiscriminant (File         : in SPARK_IO.File_Type;
                                Discriminant : in ReferenceDiscriminant)
      --# global in out SPARK_IO.File_Sys;
      --# derives SPARK_IO.File_Sys from *,
      --#                                Discriminant,
      --#                                File;
   is
   begin
      case Discriminant is
         when ReadRef =>
            WriteString (File, "read");
         when WriteRef =>
            WriteString (File, "write");
         when CallRef =>
            WriteString (File, "call");
         when OtherRef =>
            WriteString (File, "other");
      end case;
   end WriteDiscriminant;

   --------------------------------------------------------------------------------

begin
   if SPARK_IO.Is_Open (Dict.TemporaryFile) then
      WriteDiscriminant (Dict.TemporaryFile, Discriminant);
      WriteString (Dict.TemporaryFile, " reference to ");
      WriteName (Dict.TemporaryFile, Item);
      WriteString (Dict.TemporaryFile, " in ");
      WriteName (Dict.TemporaryFile, CompilationUnit);
      WriteString (Dict.TemporaryFile, " is at ");
      WriteLocation (Dict.TemporaryFile, Reference);
      WriteLine (Dict.TemporaryFile, " ;");
   end if;
end WriteReference;
