-- $Id: dictionary-writename.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure WriteName (File : in SPARK_IO.File_Type; Item : in Symbol)
is
   LocalItem    : Symbol;

   --------------------------------------------------------------------------------

   procedure WritePrefix (File : in SPARK_IO.File_Type; Item : in Symbol)
      --# global in     Dict;
      --#        in     LexTokenManager.StringTable;
      --#        in out SPARK_IO.File_Sys;
      --# derives SPARK_IO.File_Sys from *,
      --#                                Dict,
      --#                                File,
      --#                                Item,
      --#                                LexTokenManager.StringTable;
   is

      Prefix, Name : EStrings.T;
      Region       : Symbol;
      Scope        : Scopes;

      --------------------------------------------------------------------------------

      function AppendName (Prefix, Suffix : EStrings.T) return EStrings.T
      is
         Name : EStrings.T;
      begin
         Name := Prefix;
         EStrings.AppendString (Name, ".");
         EStrings.AppendExaminerString (Name, Suffix);
         return Name;
      end AppendName;

      --------------------------------------------------------------------------------

   begin
      Prefix.Length := 0; -- Intentional non-init of array
      if Item /= GetPredefinedPackageStandard then -- don't try and get a prefix for this!
         Scope := GetScope (Item);
         loop
            Region := GetRegion (Scope);
            exit when Region = GetPredefinedPackageStandard;
            GenerateSimpleName (Region, ".", Name);
            --# accept Flow, 23, Prefix.Content, "Init of Prefix is partial but effective.";
            Prefix := AppendName (Name, Prefix);
            --# end accept;
            Scope := GetEnclosingScope (Scope);
         end loop;
      end if;
      --# accept Flow, 504, Prefix.Content, "Init of Prefix is partial but effective." &
      --#        Flow, 602, SPARK_IO.File_Sys, Prefix.Content, "Init of Prefix is partial but effective.";
      EStrings.PutString (File, Prefix);
   end WritePrefix; -- Init of Prefix is partial but effective.

   --------------------------------------------------------------------------------

begin
   LocalItem := Item;

   if IsType (LocalItem) and then TypeIsAccess (LocalItem) then
      SPARK_IO.Put_String (File, "access ", 0);
      LocalItem := DeReference (LocalItem);
   end if;

   if not IsUnknownTypeMark (Item) then
      WritePrefix (File, LocalItem);
   end if;
   WriteSimpleName (File, LocalItem);
end WriteName;
