-- $Id: dictionary-writelocation.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure WriteLocation (File : in SPARK_IO.File_Type; Loc : in Location)
is

   --------------------------------------------------------------------------------

   procedure WriteTokenPosition (File : in SPARK_IO.File_Type;
                                 Pos  : in LexTokenManager.TokenPosition)
      --# global in out SPARK_IO.File_Sys;
      --# derives SPARK_IO.File_Sys from *,
      --#                                File,
      --#                                Pos;
   is

      --------------------------------------------------------------------------------

      procedure WriteLineNumber (File  : in SPARK_IO.File_Type;
                                 Value : in LexTokenManager.LineNumbers)
         --# global in out SPARK_IO.File_Sys;
         --# derives SPARK_IO.File_Sys from *,
         --#                                File,
         --#                                Value;
      is
      begin
         WriteInteger (File, Integer (Value));
      end WriteLineNumber;

      --------------------------------------------------------------------------------

   begin
      WriteString (File, "line ");
      WriteLineNumber (File, Pos.StartLineNo);
      WriteString (File, " column ");
      WriteInteger (File, Pos.StartPos);
   end WriteTokenPosition;

   --------------------------------------------------------------------------------

begin
   EStrings.PutString (File, Dict.FileName);
   WriteSpace (File);
   WriteTokenPosition (File, Loc.StartPosition);
   WriteString (File, " to ");
   WriteTokenPosition (File, Loc.EndPosition);
end WriteLocation;
