-- $Id: dictionary-instantiatesubprogramparameters.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure InstantiateSubprogramParameters (GenericSubprogramSym : in Symbol;
                                           ActualSubprogramSym  : in Symbol)
is

   function SubstituteType (PossiblyGenericType : Symbol;
                            Subprogram          : Symbol) return Symbol
   --# global in Dict;
   is
      Result : Symbol;
   begin
      if TypeIsGeneric (PossiblyGenericType) then
         Result := ActualOfGenericFormal (PossiblyGenericType,
                                          Subprogram);
      else
         Result := PossiblyGenericType;
      end if;
      return Result;
   end SubstituteType;

   procedure SubstituteReturnValue (GenericSubprogramSym : in Symbol;
                                    ActualSubprogramSym  : in Symbol)
   --# global in out Dict;
   --# derives Dict from *,
   --#                   ActualSubprogramSym,
   --#                   GenericSubprogramSym;
   is
      GenericReturnType,
      ActualReturnType,
      ProofFunction      : Symbol;
   begin
      GenericReturnType := RawDict.GetSubprogramReturnType (GenericSubprogramSym);
      if GenericReturnType /= NullSymbol then
         ActualReturnType := SubstituteType (GenericReturnType,
                                             ActualSubprogramSym);
         -- set actual return type for the instantiation
         RawDict.SetSubprogramReturnType (ActualSubprogramSym, ActualReturnType);
         -- create an implcit proof function to go with the new Ada function
         RawDict.CreateImplicitProofFunction (ActualSubprogramSym, ProofFunction);
         RawDict.SetSubprogramImplicitProofFunction (IsAbstract,
                                                     ActualSubprogramSym,
                                                     ProofFunction);
      end if;
   end SubstituteReturnValue;

   ----------------------

   procedure SubstituteParameters (GenericSubprogramSym : in Symbol;
                                   ActualSubprogramSym  : in Symbol)
   --# global in out Dict;
   --# derives Dict from *,
   --#                   ActualSubprogramSym,
   --#                   GenericSubprogramSym;
   is
      GenericParameter,
      GenericParameterType,
      ActualParameterType  : Symbol;
      GenericParameterName : LexTokenManager.LexString;
      GenericParameterMode : Modes;
      ThePreviousParameter,
      TheNewParameter      : Symbol;
   begin -- SubstituteParameters
      GenericParameter := RawDict.GetSubprogramFirstParameter (GenericSubprogramSym);
      while GenericParameter /= NullSymbol loop
         -- get generic parameter details
         GenericParameterName := RawDict.GetSubprogramParameterName (GenericParameter);
         GenericParameterType := RawDict.GetSubprogramParameterType (GenericParameter);
         GenericParameterMode := RawDict.GetSubprogramParameterMode (GenericParameter);
         -- substitute type
         ActualParameterType := SubstituteType (GenericParameterType,
                                                ActualSubprogramSym);
         -- create new parameter for instantiation
         RawDict.CreateSubprogramParameter (GenericParameterName,
                                            ActualSubprogramSym,
                                            ActualParameterType,
                                            GenericParameterMode,
                                             -- to get
                                            TheNewParameter);
         -- link it in
         ThePreviousParameter := RawDict.GetSubprogramLastParameter (ActualSubprogramSym);
         if ThePreviousParameter = NullSymbol then
            RawDict.SetSubprogramFirstParameter (ActualSubprogramSym, TheNewParameter);
         else
            RawDict.SetNextSubprogramParameter (ThePreviousParameter, TheNewParameter);
         end if;
         RawDict.SetSubprogramLastParameter (ActualSubprogramSym, TheNewParameter);

         -- move on to next parameter
         GenericParameter := RawDict.GetNextSubprogramParameter (GenericParameter);
      end loop;
   end SubstituteParameters;

   ----------------------

   procedure SubstituteDerives (GenericSubprogramSym,
                                ActualSubprogramSym : Symbol)
   --# global in     LexTokenManager.StringTable;
   --#        in out Dict;
   --#        in out SPARK_IO.File_Sys;
   --# derives Dict              from *,
   --#                                ActualSubprogramSym,
   --#                                GenericSubprogramSym &
   --#         SPARK_IO.File_Sys from *,
   --#                                ActualSubprogramSym,
   --#                                Dict,
   --#                                GenericSubprogramSym,
   --#                                LexTokenManager.StringTable;
   is
      ExportIt,
      DependencyIt : Iterator;
      TheExport : Symbol;
      NullLocation : constant Location :=
        Location'(LexTokenManager.TokenPosition'(0, 0),
                  LexTokenManager.TokenPosition'(0, 0));
   begin
      ExportIt := FirstExport (IsAbstract,
                               GenericSubprogramSym);
      while not IsNullIterator (ExportIt) loop
         TheExport := CurrentSymbol (ExportIt);
         AddExport (IsAbstract,
                    ActualSubprogramSym,
                    ActualParameterOfGenericParameter (TheExport,
                                                       ActualSubprogramSym),
                    NullLocation,
                    NullLocation);

         DependencyIt := FirstDependency (IsAbstract,
                                          GenericSubprogramSym,
                                          TheExport);
         while not IsNullIterator (DependencyIt) loop
            AddDependency (IsAbstract,
                           ActualSubprogramSym,
                           ActualParameterOfGenericParameter (TheExport,
                                                              ActualSubprogramSym),
                           ActualParameterOfGenericParameter (CurrentSymbol (DependencyIt),
                                                              ActualSubprogramSym),
                           NullLocation);
            DependencyIt := NextSymbol (DependencyIt);
         end loop;
         ExportIt := NextSymbol (ExportIt);
      end loop;
   end SubstituteDerives;

   ----------------------

begin -- InstantiateSubprogramParameters
   SubstituteReturnValue (GenericSubprogramSym,
                          ActualSubprogramSym);

   SubstituteParameters (GenericSubprogramSym,
                         ActualSubprogramSym);

   SubstituteDerives (GenericSubprogramSym,
                      ActualSubprogramSym);

   -- copy pre/posts - just copy pointers
   RawDict.SetSubprogramPrecondition (IsAbstract,
                                      ActualSubprogramSym,
                                      RawDict.GetSubprogramPrecondition (IsAbstract,
                                                                         GenericSubprogramSym));
   RawDict.SetSubprogramPostcondition (IsAbstract,
                                      ActualSubprogramSym,
                                      RawDict.GetSubprogramPostcondition (IsAbstract,
                                                                          GenericSubprogramSym));
end InstantiateSubprogramParameters;
