-- $Id: dictionary-getscope.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
function GetScope (Item : Symbol) return Scopes
is

   Scope     : Scopes;
   ItemLocal : Symbol;

   --------------------------------------------------------------------------------

   function GetDeclarativeItemScope (Item : Symbol) return Scopes
   --# global in Dict;
   is
   begin
      return RawDict.GetDeclarationScope (GetDeclaration (Item));
   end GetDeclarativeItemScope;

   --------------------------------------------------------------------------------

   function GetImplicitProofFunctionScope (ProofFunction : Symbol) return Scopes
   --# global in Dict;
   is
      AdaFunction : Symbol;
      Scope       : Scopes;
   begin

      AdaFunction := GetAdaFunction (ProofFunction);
      Scope := GetDeclarativeItemScope (AdaFunction);

      if RawDict.GetSubprogramImplicitProofFunction (IsRefined, AdaFunction) = ProofFunction then --461
         Scope := GetLocalScope (Scope);
      end if;

      return Scope;

   end GetImplicitProofFunctionScope;

   --------------------------------------------------------------------------------

   function GetVariableScope (Variable : Symbol) return Scopes
   --# global in Dict;
   is
      Scope      : Scopes;
      ThePackage : Symbol;
   begin
      if IsDeclared (Variable) then
         Scope := GetDeclarativeItemScope (Variable);
      else
         ThePackage := GetOwner (Variable);

         if IsOwnVariable (Variable) or else
           IsOwnTask (Variable) then
            Scope := VisibleScope (ThePackage);
         else
            Scope := LocalScope (ThePackage);
         end if;

      end if;

      return Scope;

   end GetVariableScope;

   --------------------------------------------------------------------------------

   procedure InvalidGetScopeRequest
   --# derives ;
   is
   begin
      SystemErrors.FatalError (SystemErrors.InvalidSymbolTable, "in InvalidGetScopeRequest");
   end InvalidGetScopeRequest;

begin
   ItemLocal := Item;
   -- if the symbol is a special on loop entry variable we use the original variable
   -- to determine whether a prefix is needed
   if RawDict.GetSymbolDiscriminant (ItemLocal) = LoopEntryVariableSymbol then
      ItemLocal := RawDict.GetLoopEntryVariableOriginalVar (ItemLocal);
   end if;

   -- Useful statements for investigating an InvalidGetScopeRequest failure
   -- Debug.PrintMsg ("Discriminant on entry to GetScope case statement is ", False);
   -- Debug.PrintMsg (SymbolDiscriminant'Image (RawDict.GetSymbolDiscriminant (ItemLocal)), True);

   case RawDict.GetSymbolDiscriminant (ItemLocal) is
      when TypeSymbol | ConstantSymbol | SubprogramSymbol | PackageSymbol =>
         Scope := GetDeclarativeItemScope (ItemLocal);
      when ImplicitProofFunctionSymbol =>
         Scope := GetImplicitProofFunctionScope (ItemLocal);
      when SubprogramParameterSymbol =>
         Scope := LocalScope (GetSubprogram (ItemLocal));
      when ParameterConstraintSymbol =>
         Scope := LocalScope (GetSubprogram (RawDict.GetParameterConstraintParameter (ItemLocal)));
      when GenericParameterSymbol =>
         Scope := LocalScope (RawDict.GetGenericParameterOwningGeneric (ItemLocal));
      when ImplicitReturnVariableSymbol =>
         Scope := LocalScope (RawDict.GetImplicitReturnVariableFunction (ItemLocal));
      when VariableSymbol =>
         Scope := GetVariableScope (ItemLocal);
      when QuantifiedVariableSymbol =>
         Scope := LocalScope (RawDict.GetQuantifiedVariableRegion (ItemLocal));
      when LoopSymbol =>
         Scope := LocalScope (RawDict.GetLoopRegion (ItemLocal));
      when LoopParameterSymbol =>
         Scope := LocalScope (RawDict.GetLoopParameterLoop (ItemLocal));
      when EnumerationLiteralSymbol =>
         Scope := GetDeclarativeItemScope (GetType (ItemLocal));
      when RecordComponentSymbol =>                               -- new, was in others part
         Scope := LocalScope (GetRecordType (ItemLocal));
      when KnownDiscriminantSymbol =>
         Scope := VisibleScope (RawDict.GetDiscriminantProtectedType (ItemLocal));
      when ConstituentSymbol =>
         Scope := GetVariableScope (RawDict.GetConstituentVariable (ItemLocal));
      when others =>
         InvalidGetScopeRequest;
         -- unreachable because previous statement halts execution; here to prevent apparent DF error
         Scope := GlobalScope;
   end case;

   return Scope;

end GetScope;
