-- $Id: dictionary-getscalarattributevalue.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
function GetScalarAttributeValue (Base     : Boolean;
                                  Name     : LexTokenManager.LexString;
                                  TypeMark : Symbol) return LexTokenManager.LexString
is

   Result : LexTokenManager.LexString;

   --------------------------------------------------------------------------------

   function GetBaseAttributeValue (Name     : LexTokenManager.LexString;
                                   TypeMark : Symbol) return LexTokenManager.LexString
      --# global in Dict;
   is
      Result : LexTokenManager.LexString;
      BaseType : Symbol;
   begin

      -- set default case; override for various successes
      Result := LexTokenManager.NullString;
      BaseType := GetBaseType (TypeMark);
      if BaseType /= NullSymbol then
         if Name = LexTokenManager.FirstToken then
            if TypeIsInteger (TypeMark) or else
              TypeIsEnumeration (TypeMark) or else
              TypeIsModular (TypeMark) or else
              TypeIsFloatingPoint (TypeMark) then
               Result := RawDict.GetTypeLower (BaseType);
            end if;
         elsif Name = LexTokenManager.LastToken then
            if TypeIsInteger (TypeMark) or else
              TypeIsEnumeration (TypeMark) or else
              TypeIsModular (TypeMark) or else
              TypeIsFloatingPoint (TypeMark) then
               Result := RawDict.GetTypeUpper (BaseType);
            end if;
         end if;
      end if;
      return Result;

   end GetBaseAttributeValue;

   --------------------------------------------------------------------------------

   function GetAttributeValue (Name     : LexTokenManager.LexString;
                               TypeMark : Symbol) return LexTokenManager.LexString
      --# global in Dict;
   is
      Result : LexTokenManager.LexString;
   begin

      if Name = LexTokenManager.DeltaToken or else
         Name = LexTokenManager.DigitsToken then

         Result := RawDict.GetTypeErrorBound (TypeMark);

      elsif Name = LexTokenManager.FirstToken then

         if TypeIsScalar (TypeMark) then
            Result := RawDict.GetTypeLower (TypeMark);
         else
            Result := RawDict.GetTypeLower (GetArrayIndex (TypeMark, 1));
         end if;

      elsif Name = LexTokenManager.LastToken then

         if TypeIsScalar (TypeMark) then
            Result := RawDict.GetTypeUpper (TypeMark);
         else
            Result := RawDict.GetTypeUpper (GetArrayIndex (TypeMark, 1));
         end if;

      elsif Name = LexTokenManager.ModulusToken then

         Result := RawDict.GetTypeModulus (TypeMark);

      else
         Result := LexTokenManager.NullString;
      end if;

      return Result;

   end GetAttributeValue;

   --------------------------------------------------------------------------------

begin

   if TypeIsUnknown (TypeMark) then
      Result := LexTokenManager.NullString;
   elsif Base then
      Result := GetBaseAttributeValue (Name, GetRootType (TypeMark));
   else
      Result := GetAttributeValue (Name, TypeMark);
   end if;

   return Result;

end GetScalarAttributeValue;
