-- $Id: dictionary-getscalarattributetype.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
function GetScalarAttributeType (Name     : LexTokenManager.LexString;
                                 TypeMark : Symbol) return Symbol
is

   Result : Symbol;

   --------------------------------------------------------------------------------

   function GetRangeAttributeType (TypeMark : Symbol) return Symbol
      --# global in Dict;
   is
      Result : Symbol;
   begin

      if TypeIsArray (TypeMark) then
         Result := GetArrayIndex (TypeMark, 1);
      else
         Result := TypeMark;
      end if;

      return Result;

   end GetRangeAttributeType;

   --------------------------------------------------------------------------------

begin

   if Name = LexTokenManager.AftToken or else
      Name = LexTokenManager.DigitsToken or else
      Name = LexTokenManager.EmaxToken or else
      Name = LexTokenManager.ForeToken or else
      Name = LexTokenManager.LengthToken or else
      Name = LexTokenManager.MachineEmaxToken or else
      Name = LexTokenManager.MachineEminToken or else
      Name = LexTokenManager.MachineMantissaToken or else
      Name = LexTokenManager.MachineRadixToken or else
      Name = LexTokenManager.MantissaToken or else
      Name = LexTokenManager.PosToken or else
      Name = LexTokenManager.SafeEmaxToken or else
      Name = LexTokenManager.SizeToken or else
      Name = LexTokenManager.Model_EminToken or else
      Name = LexTokenManager.Model_MantissaToken or else
      Name = LexTokenManager.Model_EminToken or else
      Name = LexTokenManager.ModulusToken
   then
      Result := GetUniversalIntegerType;

   elsif Name = LexTokenManager.DeltaToken or else
      Name = LexTokenManager.EpsilonToken or else
      Name = LexTokenManager.LargeToken or else
      Name = LexTokenManager.SafeLargeToken or else
      Name = LexTokenManager.SafeSmallToken or else
      Name = LexTokenManager.SmallToken or else
      Name = LexTokenManager.Model_EpsilonToken or else
      Name = LexTokenManager.Model_SmallToken or else
      Name = LexTokenManager.Safe_FirstToken or else
      Name = LexTokenManager.Safe_LastToken
   then
      Result := GetUniversalRealType;

   elsif Name = LexTokenManager.FirstToken or else
      Name = LexTokenManager.LastToken or else
      Name = LexTokenManager.RangeToken
   then
      Result := GetRangeAttributeType (TypeMark);

   elsif Name = LexTokenManager.MachineOverflowsToken or else
      Name = LexTokenManager.MachineRoundsToken or else
      Name = LexTokenManager.DenormToken or else
      Name = LexTokenManager.Signed_ZerosToken or else
      Name = LexTokenManager.ValidToken
   then
      Result := GetPredefinedBooleanType;

   elsif Name = LexTokenManager.PredToken or else
     Name = LexTokenManager.SuccToken or else
     Name = LexTokenManager.ValToken or else
     Name = LexTokenManager.MinToken or else
     Name = LexTokenManager.MaxToken or else
     Name = LexTokenManager.TailToken or else   -- 'Tail   is a proof attribute
     Name = LexTokenManager.AppendToken or else -- 'Append is a proof attribute
     Name = LexTokenManager.CeilingToken or else
     Name = LexTokenManager.FloorToken then
      Result := GetRootType (TypeMark);

   elsif Name = LexTokenManager.AccessToken then
      Result := GetAccess (TypeMark);

   else
      Result := NullSymbol;
   end if;

   return Result;

end GetScalarAttributeType;
