-- $Id: dictionary-getinheritdepth.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

separate (Dictionary)
function GetInheritDepth (FieldName    : LexTokenManager.LexString;
                          RecordType   : Symbol) return Natural

is
   Component      : Symbol;
   CurrentRecord  : Symbol;
   FirstComponent : Symbol;
   Result : Natural := 0;
begin
   CurrentRecord := RecordType;
   loop
      FirstComponent := RawDict.GetTypeFirstRecordComponent (CurrentRecord);
      Component := FirstComponent;

      loop
         exit when Component = NullSymbol; -- did not find
         exit when RawDict.GetRecordComponentName (Component) = FieldName; -- found
         Component := RawDict.GetNextRecordComponent (Component);
      end loop;
      exit when Component /= NullSymbol; -- carry success out of outer loop

      -- if we get here we failed to find field in local declarations
      -- so we search in inherited fields if there are any
      exit when not RecordComponentIsInherited (FirstComponent); -- no inherited fields

      -- restart search in inherited fields
      CurrentRecord := RawDict.GetRecordComponentType (FirstComponent);
      Result := Result + 1;
   end loop;

   return Result;

end GetInheritDepth;
