-- $Id: dictionary-forceimport.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure ForceImport (Abstraction     : in Abstractions;
                       TheProcedure    : in Symbol;
                       TheImport       : in Symbol;
                       ImportReference : in Location)
is

   --------------------------------------------------------------------------------

   procedure AddSubprogramParameterImport (Abstraction : in Abstractions;
                                           TheImport   : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Abstraction,
      --#                   TheImport;
   is
   begin
      RawDict.SetSubprogramParameterImported (Abstraction, TheImport);
   end AddSubprogramParameterImport;

   --------------------------------------------------------------------------------

   procedure AddGlobalVariableImport (Abstraction  : in Abstractions;
                                      TheProcedure : in Symbol;
                                      TheImport    : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Abstraction,
      --#                   TheImport,
      --#                   TheProcedure;
   is
   begin
      RawDict.SetGlobalVariableImported (GetGlobalVariable (Abstraction,
                                                            TheProcedure,
                                                            TheImport));
   end AddGlobalVariableImport;

   --------------------------------------------------------------------------------

begin

   if IsFormalParameter (TheProcedure, TheImport) then
      AddSubprogramParameterImport (Abstraction, TheImport);
   else
      AddGlobalVariableImport (Abstraction, TheProcedure, TheImport);
   end if;

   AddOtherReference (TheImport, TheProcedure, ImportReference);

end ForceImport;
