-- $Id: dictionary-attributeisvisiblebutobselete.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

----------------------------------------------------------------------------------------
-- If more attributes need to be added as obselete, it is recommended to follow
-- the structure of AttributeIsVisible, the skeleton of which is present here.


separate (Dictionary)

function AttributeIsVisibleButObselete (Name     : LexTokenManager.LexString;
                                        Prefix   : PrefixSort;
                                        TypeMark : Symbol;
                                        Scope    : Scopes) return Boolean
is

   Result : Boolean;

   --------------------------------------------------------------------------------
   -- Case analysis here is derived from AARM A.5.3 (72.d - 72.f) and
   -- AARM A.5.4 (4.a - 4.c)
   --------------------------------------------------------------------------------
   function TypeAttributeIsVisibleButObselete95 (Name     : LexTokenManager.LexString;
                                                 TypeMark : Symbol) return Boolean
      --# global in Dict;
   is
      Result : Boolean;
   begin

      if Name = LexTokenManager.SafeEmaxToken or else
         Name = LexTokenManager.EmaxToken or else
         Name = LexTokenManager.SmallToken or else
         Name = LexTokenManager.EpsilonToken
      then
         Result := TypeIsFloatingPoint (TypeMark) or else TypeIsUnknown (TypeMark);

      elsif Name = LexTokenManager.MantissaToken or else
         Name = LexTokenManager.SafeLargeToken or else
         Name = LexTokenManager.SafeSmallToken or else
         Name = LexTokenManager.LargeToken
      then
         Result := TypeIsReal (TypeMark) or else TypeIsUnknown (TypeMark);

      else
         Result := False;
      end if;

      return Result;

   end TypeAttributeIsVisibleButObselete95;

   --------------------------------------------------------------------------------

   function TypeAttributeIsVisibleButObselete (Name     : LexTokenManager.LexString;
                                               TypeMark : Symbol) return Boolean
      --# global in CommandLineData.Content;
      --#        in Dict;
   is
      Result : Boolean;
   begin
      if CommandLineData.IsSpark95 then
         Result := TypeAttributeIsVisibleButObselete95 (Name, TypeMark);
      else
         Result := False; -- Currently none such handled
      end if;
      return Result;
   end TypeAttributeIsVisibleButObselete;

   --------------------------------------------------------------------------------

begin
   SystemErrors.RTAssert (IsTypeMark (TypeMark) or else IsUnknownTypeMark (TypeMark),
                          SystemErrors.PreconditionFailure,
                          "In call to AttributeIsVisibleButObselete");

   if TypeIsPrivateHere (TypeMark, Scope) then
      Result := False;
   else
      case Prefix is
         when AType =>
            Result := TypeAttributeIsVisibleButObselete (Name, TypeMark);
         when ABaseType =>
            Result := False; -- Currently none such handled
         when AnObject =>
            Result := False; -- Currently none such handled
      end case;
   end if;

   return Result;

end AttributeIsVisibleButObselete;
