-- $Id: dictionary-attributeisvisible.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with CommandLineData;

separate (Dictionary)
function AttributeIsVisible (Name     : LexTokenManager.LexString;
                             Prefix   : PrefixSort;
                             TypeMark : Symbol;
                             Scope    : Scopes) return Boolean
is

   Result : Boolean;

   --------------------------------------------------------------------------------

   function TypeAttributeIsVisible83 (Name     : LexTokenManager.LexString;
                                      TypeMark : Symbol) return Boolean
      --# global in Dict;
   is
      Result : Boolean;
   begin

      if Name = LexTokenManager.AftToken or else
         Name = LexTokenManager.DeltaToken or else
         Name = LexTokenManager.ForeToken then
         Result := TypeIsFixedPoint (TypeMark) or else TypeIsUnknown (TypeMark);
      elsif Name = LexTokenManager.SizeToken then
         Result := True;
      elsif Name = LexTokenManager.DigitsToken or else
        Name = LexTokenManager.EmaxToken or else
        Name = LexTokenManager.EpsilonToken or else
        Name = LexTokenManager.MachineEmaxToken or else
        Name = LexTokenManager.MachineEminToken or else
        Name = LexTokenManager.MachineMantissaToken or else
        Name = LexTokenManager.MachineRadixToken or else
        Name = LexTokenManager.SafeEmaxToken
      then
         Result := TypeIsFloatingPoint (TypeMark) or else TypeIsUnknown (TypeMark);
      elsif Name = LexTokenManager.FirstToken or else
         Name = LexTokenManager.LastToken then
         if TypeIsScalar (TypeMark) then
            Result := True;
         elsif TypeIsArray (TypeMark) then
            Result := ArrayTypeIsConstrained (TypeMark);
         else
            Result := TypeIsUnknown (TypeMark);
         end if;
      elsif Name = LexTokenManager.LargeToken or else
         Name = LexTokenManager.MachineOverflowsToken or else
         Name = LexTokenManager.MachineRoundsToken or else
         Name = LexTokenManager.MantissaToken or else
         Name = LexTokenManager.SafeLargeToken or else
         Name = LexTokenManager.SafeSmallToken or else
         Name = LexTokenManager.SmallToken then
         Result := TypeIsReal (TypeMark) or else TypeIsUnknown (TypeMark);
      elsif Name = LexTokenManager.LengthToken or else
         Name = LexTokenManager.RangeToken then
         if TypeIsArray (TypeMark) then
            Result := ArrayTypeIsConstrained (TypeMark) or else
               IsSubtype (TypeMark);
         else
            Result := TypeIsUnknown (TypeMark);
         end if;
      elsif Name = LexTokenManager.PosToken or else
         Name = LexTokenManager.PredToken or else
         Name = LexTokenManager.SuccToken or else
         Name = LexTokenManager.ValToken then
         if TypeIsDiscrete (TypeMark) then
            Result := not TypeIsBoolean (TypeMark);
         else
            Result := TypeIsUnknown (TypeMark);
         end if;
      else
         Result := False;
      end if;

      return Result;

   end TypeAttributeIsVisible83;

   --------------------------------------------------------------------------------


   function TypeAttributeIsVisible95 (Name     : LexTokenManager.LexString;
                                      TypeMark : Symbol) return Boolean
      --# global in Dict;
   is
      Result : Boolean;
   begin

      if Name = LexTokenManager.AftToken or else
         Name = LexTokenManager.DeltaToken or else
         Name = LexTokenManager.ForeToken
      then
         Result := TypeIsFixedPoint (TypeMark) or else TypeIsUnknown (TypeMark);

      elsif Name = LexTokenManager.SizeToken then
         Result := True;

      elsif Name = LexTokenManager.DigitsToken or else
        Name = LexTokenManager.MachineEmaxToken or else
        Name = LexTokenManager.MachineEminToken or else
        Name = LexTokenManager.MachineMantissaToken or else
        Name = LexTokenManager.DenormToken or else
        Name = LexTokenManager.Model_EminToken or else
        Name = LexTokenManager.Model_EpsilonToken or else
        Name = LexTokenManager.Model_MantissaToken or else
        Name = LexTokenManager.Model_SmallToken or else
        Name = LexTokenManager.Safe_FirstToken or else
        Name = LexTokenManager.Safe_LastToken or else
        Name = LexTokenManager.Signed_ZerosToken or else
        Name = LexTokenManager.FloorToken or else
        Name = LexTokenManager.CeilingToken or else
        Name = LexTokenManager.SafeEmaxToken or else -- Obsolete but implementation-defined in SPARK95
        Name = LexTokenManager.EmaxToken or else     -- Ditto
        Name = LexTokenManager.EpsilonToken          -- Ditto
      then
         Result := TypeIsFloatingPoint (TypeMark) or else TypeIsUnknown (TypeMark);

      elsif Name = LexTokenManager.FirstToken or else
         Name = LexTokenManager.LastToken then
         if TypeIsScalar (TypeMark) then
            Result := True;
         elsif TypeIsArray (TypeMark) then
            Result := ArrayTypeIsConstrained (TypeMark);
         else
            Result := TypeIsUnknown (TypeMark);
         end if;

      elsif Name = LexTokenManager.MachineOverflowsToken or else
         Name = LexTokenManager.MachineRoundsToken or else
         Name = LexTokenManager.MachineRadixToken or else
         Name = LexTokenManager.LargeToken or else     -- Obsolete but implementation-defined in SPARK95
         Name = LexTokenManager.MantissaToken or else  -- Ditto
         Name = LexTokenManager.SafeLargeToken or else -- Ditto
         Name = LexTokenManager.SafeSmallToken or else -- Ditto
         Name = LexTokenManager.SmallToken   -- Obsolete but implementation-defined
                                             -- for floating-point types in SPARK95.
                                             -- OK for fixed-point types.
      then
         Result := TypeIsReal (TypeMark) or else TypeIsUnknown (TypeMark);

      elsif Name = LexTokenManager.LengthToken or else
         Name = LexTokenManager.RangeToken then
         if TypeIsArray (TypeMark) then
            Result := ArrayTypeIsConstrained (TypeMark) or else
               IsSubtype (TypeMark);
         else
            Result := TypeIsUnknown (TypeMark);
         end if;

      elsif Name = LexTokenManager.PosToken or else
         Name = LexTokenManager.PredToken or else
         Name = LexTokenManager.SuccToken or else
         Name = LexTokenManager.ValToken then
         if TypeIsDiscrete (TypeMark) then
            Result := not TypeIsBoolean (TypeMark);
         else
            Result := TypeIsUnknown (TypeMark);
         end if;

      elsif Name = LexTokenManager.Component_SizeToken then
         Result := TypeIsArray (TypeMark);

      elsif Name = LexTokenManager.MinToken or else
         Name = LexTokenManager.MaxToken then
         Result := (TypeIsScalar (TypeMark) and then
                    not TypeIsBoolean (TypeMark)) or else TypeIsUnknown (TypeMark);

      elsif Name = LexTokenManager.ModulusToken then
         Result := TypeIsModular (TypeMark) or else TypeIsUnknown (TypeMark);

      else
         Result := False;
      end if;

      return Result;

   end TypeAttributeIsVisible95;

   --------------------------------------------------------------------------------

   function TypeAttributeIsVisible (Name     : LexTokenManager.LexString;
                                    TypeMark : Symbol) return Boolean
      --# global in CommandLineData.Content;
      --#        in Dict;
   is
      Result : Boolean;
   begin
      if CommandLineData.IsSpark95 then
         Result := TypeAttributeIsVisible95 (Name, TypeMark);
      else
         Result := TypeAttributeIsVisible83 (Name, TypeMark);
      end if;
      return Result;
   end TypeAttributeIsVisible;

   -------------------------------------------------------------------------------

   function BaseAttributeIsVisible (Name     : LexTokenManager.LexString;
                                    TypeMark : Symbol) return Boolean
      --# global in CommandLineData.Content;
      --#        in Dict;
   is
      Result : Boolean;
   begin

      if TypeAttributeIsVisible (Name, TypeMark) then
         if Name = LexTokenManager.FirstToken or else
            Name = LexTokenManager.LastToken then
            Result := not TypeIsArray (TypeMark);
         elsif Name = LexTokenManager.LengthToken or else
            Name = LexTokenManager.RangeToken then
            Result := False;
         else
            Result := True;
         end if;
      else
         Result := False;
      end if;

      return Result;

   end BaseAttributeIsVisible;

   --------------------------------------------------------------------------------

   function ObjectAttributeIsVisible83 (Name     : LexTokenManager.LexString;
                                        TypeMark : Symbol) return Boolean
      --# global in Dict;
   is
      Result : Boolean;
   begin

      if Name = LexTokenManager.SizeToken then
         Result := True;
      elsif Name = LexTokenManager.FirstToken or else
         Name = LexTokenManager.LastToken or else
         Name = LexTokenManager.LengthToken or else
         Name = LexTokenManager.RangeToken then
         Result := TypeIsArray (TypeMark);
      else
         Result := False;
      end if;

      return Result;

   end ObjectAttributeIsVisible83;

   --------------------------------------------------------------------------------

   function ObjectAttributeIsVisible95 (Name     : LexTokenManager.LexString;
                                        TypeMark : Symbol) return Boolean
   --# global in CommandLineData.Content;
   --#        in Dict;
   is
      Result : Boolean;
   begin

      if Name = LexTokenManager.SizeToken then
         Result := True;

      elsif Name = LexTokenManager.FirstToken or else
         Name = LexTokenManager.LastToken or else
         Name = LexTokenManager.LengthToken or else
         Name = LexTokenManager.RangeToken or else
         Name = LexTokenManager.Component_SizeToken
      then
         Result := TypeIsArray (TypeMark);

         -- Support for 'Valid in SPARK95
      elsif Name = LexTokenManager.ValidToken then
         -- LRM 13.9.2 (2) says 'Valid is only allowed for a prefix that
         -- denotes a scalar type.
         Result := TypeIsScalar (TypeMark);

      elsif Name = LexTokenManager.AccessToken then
         Result := TypeIsProtected (TypeMark) and then
           CommandLineData.RavenscarSelected;
      else
         Result := False;
      end if;

      return Result;

   end ObjectAttributeIsVisible95;

   --------------------------------------------------------------------------------

begin
   SystemErrors.RTAssert (IsTypeMark (TypeMark) or else IsUnknownTypeMark (TypeMark),
                          SystemErrors.PreconditionFailure,
                          "In call to AttributeIsVisible");

   if TypeIsPrivateHere (TypeMark, Scope) then
      Result := False;
   else
      case Prefix is
         when AType =>
            Result := TypeAttributeIsVisible (Name, TypeMark);
         when ABaseType =>
            Result := BaseAttributeIsVisible (Name, TypeMark);
         when AnObject =>
            if CommandLineData.IsSpark95 then
               Result := ObjectAttributeIsVisible95 (Name, TypeMark);
            else
               Result := ObjectAttributeIsVisible83 (Name, TypeMark);
            end if;
      end case;
   end if;

   return Result;

end AttributeIsVisible;
