-- $Id: dictionary-addwithreference.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure AddWithReference (Scope            : in     Scopes;
                            ThePackage       : in     Symbol;
                            Explicit         : in     Boolean;
                            PackageReference : in     Location;
                            AlreadyPresent   :    out Boolean)
is

   ContextClause   : Symbol;
   CompilationUnit : Symbol;
   AlreadyExplicitlyPresent,
   NeedToAdd                 : Boolean;

   --------------------------------------------------------------------------------

   procedure AddVisibleWithReference (ContextClause, ThePackage : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   ContextClause,
      --#                   ThePackage;
   is
   begin
      RawDict.SetNextContextClause (ContextClause,
                                    RawDict.GetPackageVisibleWithClauses (ThePackage));
      RawDict.SetPackageVisibleWithClauses (ThePackage, ContextClause);
   end AddVisibleWithReference;

   --------------------------------------------------------------------------------

   procedure AddLocalWithReference (ContextClause,  ThePackage : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   ContextClause,
      --#                   ThePackage;
   is
   begin
      RawDict.SetNextContextClause (ContextClause,
                                    RawDict.GetPackageLocalWithClauses (ThePackage));
      RawDict.SetPackageLocalWithClauses (ThePackage, ContextClause);
   end AddLocalWithReference;

   --------------------------------------------------------------------------------

   procedure AddSubprogramWithReference (ContextClause, Subprogram : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   ContextClause,
      --#                   Subprogram;
   is
   begin
      RawDict.SetNextContextClause (ContextClause,
                                    RawDict.GetSubprogramWithClauses (Subprogram));
      RawDict.SetSubprogramWithClauses (Subprogram, ContextClause);
   end AddSubprogramWithReference;

   --------------------------------------------------------------------------------

   procedure AddProtectedTypeWithReference (ContextClause, TheProtectedType : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   ContextClause,
      --#                   TheProtectedType;
   is
   begin
      RawDict.SetNextContextClause (ContextClause,
                                    RawDict.GetProtectedTypeWithClauses (TheProtectedType));
      RawDict.SetProtectedTypeWithClauses (TheProtectedType, ContextClause);
   end AddProtectedTypeWithReference;

   --------------------------------------------------------------------------------

   procedure AddTaskTypeWithReference (ContextClause, TheTaskType : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   ContextClause,
      --#                   TheTaskType;
   is
   begin
      RawDict.SetNextContextClause (ContextClause,
                                    RawDict.GetTaskTypeWithClauses (TheTaskType));
      RawDict.SetTaskTypeWithClauses (TheTaskType, ContextClause);
   end AddTaskTypeWithReference;

   --------------------------------------------------------------------------------

   procedure CheckIfAlreadyPresent (ThePackage               : in     Symbol;
                                    Scope                    : in     Scopes;
                                    AddingExplicit           : in     Boolean;
                                    AlreadyExplicitlyPresent :    out Boolean;
                                    NeedToAdd                :    out Boolean)
      --# global in out Dict;
      --# derives AlreadyExplicitlyPresent,
      --#         Dict                     from AddingExplicit,
      --#                                       Dict,
      --#                                       Scope,
      --#                                       ThePackage &
      --#         NeedToAdd                from Dict,
      --#                                       Scope,
      --#                                       ThePackage;
   is
      CurrentContextClause : Symbol;
      Region               : Symbol;
   begin
      AlreadyExplicitlyPresent := False;
      NeedToAdd := True;

      Region := GetRegion (Scope);

      case Scope.TypeOfScope is
         when Visible | Privat =>
            CurrentContextClause := RawDict.GetPackageVisibleWithClauses (Region);
         when Local =>
            case RawDict.GetSymbolDiscriminant (Region) is
               when PackageSymbol =>
                  CurrentContextClause := RawDict.GetPackageLocalWithClauses (Region);
               when SubprogramSymbol =>
                  CurrentContextClause := RawDict.GetSubprogramWithClauses (Region);
               when TypeSymbol =>
                  if RawDict.GetTypeDiscriminant (Region) = ProtectedType then
                     CurrentContextClause := RawDict.GetProtectedTypeWithClauses (Region);
                  elsif RawDict.GetTypeDiscriminant (Region) = TaskType then
                     CurrentContextClause := RawDict.GetTaskTypeWithClauses (Region);
                  else
                     CurrentContextClause := NullSymbol;
                  end if;
               when others =>
                  CurrentContextClause := NullSymbol;
            end case;
      end case;

      loop
         exit when CurrentContextClause = NullSymbol;
         if RawDict.GetContextClausePackage (CurrentContextClause) = ThePackage then
            NeedToAdd := False;
            if AddingExplicit then
               if RawDict.GetContextClauseExplicit (CurrentContextClause) then
                  AlreadyExplicitlyPresent := True;
               else
                  RawDict.SetContextClauseExplicit (CurrentContextClause);
               end if;
            end if;
            exit;
         end if;

         CurrentContextClause := RawDict.GetNextContextClause (CurrentContextClause);
      end loop;

   end CheckIfAlreadyPresent;

   --------------------------------------------------------------------------------

begin  --AddWithReference

   CheckIfAlreadyPresent (ThePackage,
                          Scope,
                          Explicit,
                           --to get
                          AlreadyExplicitlyPresent,
                          NeedToAdd);

   if NeedToAdd then

      RawDict.CreateContextClause (Scope,
                                   ThePackage,
                                   Explicit,
                                   ContextClause);

      CompilationUnit := GetRegion (Scope);

      case Scope.TypeOfScope is
         when Visible =>
            AddVisibleWithReference (ContextClause, CompilationUnit);
         when others =>
            case RawDict.GetSymbolDiscriminant (CompilationUnit) is
               when PackageSymbol =>
                  AddLocalWithReference (ContextClause, CompilationUnit);
               when TypeSymbol =>
                  if RawDict.GetTypeDiscriminant (CompilationUnit) = ProtectedType then
                     AddProtectedTypeWithReference (ContextClause, CompilationUnit);
                  elsif RawDict.GetTypeDiscriminant (CompilationUnit) = TaskType then
                     AddTaskTypeWithReference (ContextClause, CompilationUnit);
                  end if;
               when others =>
                  AddSubprogramWithReference (ContextClause, CompilationUnit);
            end case;
      end case;
      AddOtherReference (ThePackage, CompilationUnit, PackageReference);
   end if;
   AlreadyPresent := AlreadyExplicitlyPresent;
end AddWithReference;
