-- $Id: dictionary-addusetypereference.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure AddUseTypeReference (Scope         : in Scopes;
                               TheType       : in Symbol;
                               TypeReference : in Location)
is

   UseTypeClause   : Symbol;
   CompilationUnit : Symbol;

   --------------------------------------------------------------------------------

   procedure AddVisibleUseTypeReference (UseTypeClause, ThePackage : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   ThePackage,
      --#                   UseTypeClause;
   is
   begin
      RawDict.SetNextUseTypeClause (UseTypeClause,
                                    RawDict.GetPackageVisibleUseTypeClauses (ThePackage));
      RawDict.SetPackageVisibleUseTypeClauses (ThePackage, UseTypeClause);
   end AddVisibleUseTypeReference;

   --------------------------------------------------------------------------------

   procedure AddLocalUseTypeReference (UseTypeClause,  ThePackage : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   ThePackage,
      --#                   UseTypeClause;
   is
   begin
      RawDict.SetNextUseTypeClause (UseTypeClause,
                                    RawDict.GetPackageLocalUseTypeClauses (ThePackage));
      RawDict.SetPackageLocalUseTypeClauses (ThePackage, UseTypeClause);
   end AddLocalUseTypeReference;

   --------------------------------------------------------------------------------

   procedure AddProtectedTypeUseTypeReference (UseTypeClause, TheProtectedType : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   TheProtectedType,
      --#                   UseTypeClause;
   is
   begin
      RawDict.SetNextUseTypeClause (UseTypeClause,
                                    RawDict.GetProtectedTypeUseTypeClauses (TheProtectedType));
      RawDict.SetProtectedTypeUseTypeClauses (TheProtectedType, UseTypeClause);
   end AddProtectedTypeUseTypeReference;

   --------------------------------------------------------------------------------

   procedure AddTaskTypeUseTypeReference (UseTypeClause, TheTaskType : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   TheTaskType,
      --#                   UseTypeClause;
   is
   begin
      RawDict.SetNextUseTypeClause (UseTypeClause,
                                    RawDict.GetTaskTypeUseTypeClauses (TheTaskType));
      RawDict.SetTaskTypeUseTypeClauses (TheTaskType, UseTypeClause);
   end AddTaskTypeUseTypeReference;

   --------------------------------------------------------------------------------

   procedure AddSubprogramUseTypeReference (UseTypeClause, Subprogram : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Subprogram,
      --#                   UseTypeClause;
   is
   begin
      RawDict.SetNextUseTypeClause (UseTypeClause,
                                    RawDict.GetSubprogramUseTypeClauses (Subprogram));
      RawDict.SetSubprogramUseTypeClauses (Subprogram, UseTypeClause);
   end AddSubprogramUseTypeReference;

   --------------------------------------------------------------------------------

begin

   RawDict.CreateUseTypeClause (Scope, TheType, UseTypeClause);

   CompilationUnit := GetRegion (Scope);

   case Scope.TypeOfScope is
      when Visible =>
         AddVisibleUseTypeReference (UseTypeClause, CompilationUnit);
      when others =>
         case RawDict.GetSymbolDiscriminant (CompilationUnit) is
            when PackageSymbol =>
               AddLocalUseTypeReference (UseTypeClause, CompilationUnit);
            when TypeSymbol =>
               if RawDict.GetTypeDiscriminant (CompilationUnit) = ProtectedType then
                  AddProtectedTypeUseTypeReference (UseTypeClause, CompilationUnit);
               else -- must be task type
                  AddTaskTypeUseTypeReference (UseTypeClause, CompilationUnit);
               end if;
            when others => -- must be subprogram
               AddSubprogramUseTypeReference (UseTypeClause, CompilationUnit);
         end case;
   end case;

   AddOtherReference (TheType, CompilationUnit, TypeReference);
end AddUseTypeReference;
