-- $Id: dictionary-addsubprogramparameter.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure AddSubprogramParameter (Name          : in LexTokenManager.LexString;
                                  Subprogram    : in Symbol;
                                  TypeMark      : in Symbol;
                                  TypeReference : in Location;
                                  Mode          : in Modes;
                                  Specification : in Location)
is

   Parameter : Symbol;
   Previous  : Symbol;

   --------------------------------------------------------------------------------

   procedure WriteSubprogramParameterSpecification (Parameter     : in Symbol;
                                                    Specification : in Location)
      --# global in     Dict;
      --#        in     LexTokenManager.StringTable;
      --#        in out SPARK_IO.File_Sys;
      --# derives SPARK_IO.File_Sys from *,
      --#                                Dict,
      --#                                LexTokenManager.StringTable,
      --#                                Parameter,
      --#                                Specification;
   is
   begin
      if SPARK_IO.Is_Open (Dict.TemporaryFile) then
         WriteString (Dict.TemporaryFile, "specification of ");
         WriteName (Dict.TemporaryFile, Parameter);
         WriteString (Dict.TemporaryFile, " is at ");
         WriteLocation (Dict.TemporaryFile, Specification);
         WriteLine (Dict.TemporaryFile, " ;");
      end if;
   end WriteSubprogramParameterSpecification;

   --------------------------------------------------------------------------------

   procedure AddConstraintSymbolsIfNeeded (TypeMark     : in Symbol;
                                           TheParameter : in Symbol)
   --# global in out Dict;
   --# derives Dict from *,
   --#                   TheParameter,
   --#                   TypeMark;
   is
      procedure AddConstraintSymbol (TheParameter : in Symbol;
                                     Dimension    : in Positive)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Dimension,
      --#                   TheParameter;
      is
         NewConstraint : Symbol;
      begin
         RawDict.CreateParameterConstraint (TheParameter,
                                            Dimension,
                                             -- to get
                                            NewConstraint);
         -- Now link new constraint to subprogram parameter - list ends up in dimension order
         RawDict.SetParameterConstraintNext (NewConstraint,
                                             RawDict.GetSubprogramParameterIndexConstraints (TheParameter));
         RawDict.SetSubprogramParameterIndexConstraints (TheParameter, NewConstraint);
      end AddConstraintSymbol;

   begin -- AddConstraintSymbolsIfNeeded
      if IsUnconstrainedArrayType (TypeMark) then
         for I in reverse Positive range 1 .. GetNumberOfDimensions (TypeMark) loop
            AddConstraintSymbol (TheParameter, I);
         end loop;
      end if;
   end AddConstraintSymbolsIfNeeded;

   --------------------------------------------------------------------------------

begin -- AddSubprogramParameter

   RawDict.CreateSubprogramParameter (Name, Subprogram, TypeMark, Mode, Parameter);

   Previous := RawDict.GetSubprogramLastParameter (Subprogram);

   if Previous = NullSymbol then
      RawDict.SetSubprogramFirstParameter (Subprogram, Parameter);
   else
      RawDict.SetNextSubprogramParameter (Previous, Parameter);
   end if;

   RawDict.SetSubprogramLastParameter (Subprogram, Parameter);

   AddConstraintSymbolsIfNeeded (TypeMark, Parameter);

   if not TypeIsUnknown (TypeMark) then
      AddOtherReference (TypeMark, Subprogram, TypeReference);
   end if;

   WriteSubprogramParameterSpecification (Parameter, Specification);

end AddSubprogramParameter;
