-- $Id: dictionary-addloop.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure AddLoop (Scope         : in     Scopes;
                   LoopStatement : in     Location;
                   TheLoop       :    out Symbol)
is

   CompilationUnit, Current, Previous : Symbol;

   --------------------------------------------------------------------------------

   procedure WriteLoopStatement (TheLoop       : in Symbol;
                                 LoopStatement : in Location)
      --# global in     Dict;
      --#        in     LexTokenManager.StringTable;
      --#        in out SPARK_IO.File_Sys;
      --# derives SPARK_IO.File_Sys from *,
      --#                                Dict,
      --#                                LexTokenManager.StringTable,
      --#                                LoopStatement,
      --#                                TheLoop;
   is
   begin
      if SPARK_IO.Is_Open (Dict.TemporaryFile) then
         WriteString (Dict.TemporaryFile, "loop statement for ");
         WriteName (Dict.TemporaryFile, TheLoop);
         WriteString (Dict.TemporaryFile, " is at ");
         WriteLocation (Dict.TemporaryFile, LoopStatement);
         WriteLine (Dict.TemporaryFile, " ;");
      end if;
   end WriteLoopStatement;

   --------------------------------------------------------------------------------

begin

   RawDict.CreateLoop (GetRegion (Scope), Current);

   CompilationUnit := GetEnclosingCompilationUnit (Scope);

   case RawDict.GetSymbolDiscriminant (CompilationUnit) is
      when SubprogramSymbol =>
         Previous := RawDict.GetSubprogramLastLoop (CompilationUnit);
         if Previous = NullSymbol then
            RawDict.SetSubprogramFirstLoop (CompilationUnit, Current);
         else
            RawDict.SetNextLoop (Previous, Current);
         end if;
         RawDict.SetSubprogramLastLoop (CompilationUnit, Current);
      when TypeSymbol =>
         -- must be task body, no other type could have a loop in it
         Previous := RawDict.GetTaskTypeLastLoop (CompilationUnit);
         if Previous = NullSymbol then
            RawDict.SetTaskTypeFirstLoop (CompilationUnit, Current);
         else
            RawDict.SetNextLoop (Previous, Current);
         end if;
         RawDict.SetTaskTypeLastLoop (CompilationUnit, Current);
      when others =>
         Previous := RawDict.GetPackageLastLoop (CompilationUnit);
         if Previous = NullSymbol then
            RawDict.SetPackageFirstLoop (CompilationUnit, Current);
         else
            RawDict.SetNextLoop (Previous, Current);
         end if;
         RawDict.SetPackageLastLoop (CompilationUnit, Current);
   end case;

   WriteLoopStatement (Current, LoopStatement);

   TheLoop := Current;

end AddLoop;
