-- $Id: dictionary-addinheritsreference.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure AddInheritsReference (CompilationUnit  : in     Symbol;
                                ThePackage       : in     Symbol;
                                Explicit         : in     Boolean;
                                PackageReference : in     Location;
                                AlreadyPresent   :    out Boolean)
is
   AlreadyExplicitlyPresent,
   NeedToAdd                 : Boolean;

   --------------------------------------------------------------------------------

   procedure AddPackageInheritsReference (InheritingPackage : in Symbol;
                                          InheritedPackage  : in Symbol)
      --# global in     Explicit;
      --#        in out Dict;
      --# derives Dict from *,
      --#                   Explicit,
      --#                   InheritedPackage,
      --#                   InheritingPackage;
   is
      ContextClause : Symbol;
   begin
      RawDict.CreateContextClause (VisibleScope (InheritingPackage),
                                   InheritedPackage,
                                   Explicit,
                                   ContextClause);
      RawDict.SetNextContextClause (ContextClause,
                                    RawDict.GetPackageInheritClauses (InheritingPackage));
      RawDict.SetPackageInheritClauses (InheritingPackage, ContextClause);
   end AddPackageInheritsReference;

   --------------------------------------------------------------------------------

   procedure AddMainProgramInheritsReference (ThePackage : in Symbol)
      --# global in     Explicit;
      --#        in out Dict;
      --# derives Dict from *,
      --#                   Explicit,
      --#                   ThePackage;
   is
      Current, Next : Symbol;
   begin
      RawDict.CreateContextClause (LocalScope (GetMainProgram),
                                   ThePackage,
                                   Explicit,
                                   Current);
      Next := Dict.Main.InheritClauses;
      RawDict.SetNextContextClause (Current, Next);
      Dict.Main.InheritClauses := Current;
   end AddMainProgramInheritsReference;

   --------------------------------------------------------------------------------


   procedure CheckIfAlreadyPresent (ThePackage,
                                    CompilationUnit          : in     Symbol;
                                    AddingExplicit           : in     Boolean;
                                    AlreadyExplicitlyPresent :    out Boolean;
                                    NeedToAdd                :    out Boolean)
      --# global in out Dict;
      --# derives AlreadyExplicitlyPresent,
      --#         Dict                     from AddingExplicit,
      --#                                       CompilationUnit,
      --#                                       Dict,
      --#                                       ThePackage &
      --#         NeedToAdd                from CompilationUnit,
      --#                                       Dict,
      --#                                       ThePackage;
   is
      CurrentContextClause : Symbol;
   begin
      AlreadyExplicitlyPresent := False;
      NeedToAdd := True;

      if IsPackage (CompilationUnit) then
         CurrentContextClause := RawDict.GetPackageInheritClauses (CompilationUnit);
      elsif IsMainProgram (CompilationUnit) then
         CurrentContextClause := Dict.Main.InheritClauses;
      else
         CurrentContextClause := NullSymbol;
      end if;

      loop
         exit when CurrentContextClause = NullSymbol;
         if RawDict.GetContextClausePackage (CurrentContextClause) = ThePackage then
            NeedToAdd := False;
            if AddingExplicit then
               if RawDict.GetContextClauseExplicit (CurrentContextClause) then
                  AlreadyExplicitlyPresent := True;
               else
                  RawDict.SetContextClauseExplicit (CurrentContextClause);
               end if;
            end if;
            exit;
         end if;

         CurrentContextClause := RawDict.GetNextContextClause (CurrentContextClause);
      end loop;

   end CheckIfAlreadyPresent;

   --------------------------------------------------------------------------------

begin --AddInheritsReference

   CheckIfAlreadyPresent (ThePackage,
                          CompilationUnit,
                          Explicit,
                           --to get
                          AlreadyExplicitlyPresent,
                          NeedToAdd);

   if NeedToAdd then
      case RawDict.GetSymbolDiscriminant (CompilationUnit) is
         when PackageSymbol =>
            AddPackageInheritsReference (CompilationUnit, ThePackage);
         when others =>
            AddMainProgramInheritsReference (ThePackage);
      end case;

      AddOtherReference (ThePackage, CompilationUnit, PackageReference);
   end if;

   AlreadyPresent := AlreadyExplicitlyPresent;

end AddInheritsReference;
