-- $Id: dictionary-addgenericformalparameter.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure AddGenericFormalParameter (Name                : in LexTokenManager.LexString;
                                     SubprogramOrPackage : in Symbol;
                                     TypeMark            : in Symbol;
                                     Kind                : in GenericParameterKind)
-- Name is only used for formal objects.  In that case only, we create a constant called "Name" of type
-- TypeMark.  In the case of generic types, the name is already included in the type mark record.
is
   TheObject      : Symbol; -- only used for object parameters
   TheDeclaration : Symbol; -- only used for object parameters

   Previous       : Symbol;
   Parameter      : Symbol;

begin
   case Kind is
      when GenericTypeParameter =>
         RawDict.CreateGenericParameter (SubprogramOrPackage,
                                         TypeMark,
                                         Kind,
                                         Parameter);

      when GenericObjectParameter =>
         RawDict.CreateConstant (Name        => Name,
                                 TypeMark    => TypeMark,
                                 Static      => False,
                                 TheConstant => TheObject);
         RawDict.CreateGenericParameter (SubprogramOrPackage,
                                         TheObject,
                                         Kind,
                                         Parameter);
         -- Set a back pointer from the constant so that we know that we created it to implement a generic object
         -- parameter and know which generic parameter the constant belongs to
         RawDict.SetConstantAssociatedGenericParameter (TheObject, Parameter);
         -- Set the constant we created as being declared in the visible part of the generic unit.
         AddDeclaration (TheObject,
                         VisibleScope (SubprogramOrPackage),
                         ProgramContext,
                         TheDeclaration);
         RawDict.SetConstantDeclaration (TheObject,
                                         TheDeclaration);
   end case;


   if IsPackage (SubprogramOrPackage) then
      Previous := RawDict.GetPackageLastGenericParameter (SubprogramOrPackage);
      if Previous = NullSymbol then
         RawDict.SetPackageFirstGenericParameter (SubprogramOrPackage, Parameter);
      else
         RawDict.SetNextGenericParameter (Previous, Parameter);
      end if;
      RawDict.SetPackageLastGenericParameter (SubprogramOrPackage, Parameter);
   else -- assume subprogram
      Previous := RawDict.GetSubprogramLastGenericParameter (SubprogramOrPackage);
      if Previous = NullSymbol then
         RawDict.SetSubprogramFirstGenericParameter (SubprogramOrPackage, Parameter);
      else
         RawDict.SetNextGenericParameter (Previous, Parameter);
      end if;
      RawDict.SetSubprogramLastGenericParameter (SubprogramOrPackage, Parameter);
   end if;
end AddGenericFormalParameter;
