-- $Id: dictionary-adddeclaration.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure AddDeclaration (Item        : in     Symbol;
                          Scope       : in     Scopes;
                          Context     : in     Contexts;
                          Declaration :    out Symbol)
is
   Current : Symbol;

   --------------------------------------------------------------------------------

   procedure AddVisibleDeclaration (Declaration, Region : in Symbol)
   --# global in out Dict;
   --# derives Dict from *,
   --#                   Declaration,
   --#                   Region;
   is

      procedure AddVisibleDeclarationToPackage (Declaration, ThePackage : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Declaration,
      --#                   ThePackage;
      is
         Previous : Symbol;
      begin

         Previous := RawDict.GetPackageLastVisibleDeclaration (ThePackage);

         if Previous = NullSymbol then
            RawDict.SetPackageFirstVisibleDeclaration (ThePackage, Declaration);
         else
            RawDict.SetNextDeclaration (Previous, Declaration);
         end if;

         RawDict.SetPackageLastVisibleDeclaration (ThePackage, Declaration);

      end AddVisibleDeclarationToPackage;

   --------------------------------------------------------------------------------

      procedure AddVisibleDeclarationToProtectedType (Declaration, TheProtectedType : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Declaration,
      --#                   TheProtectedType;
      is
         Previous : Symbol;
      begin

         Previous := RawDict.GetProtectedTypeLastVisibleDeclaration (TheProtectedType);

         if Previous = NullSymbol then
            RawDict.SetProtectedTypeFirstVisibleDeclaration (TheProtectedType, Declaration);
         else
            RawDict.SetNextDeclaration (Previous, Declaration);
         end if;

         RawDict.SetProtectedTypeLastVisibleDeclaration (TheProtectedType, Declaration);

      end AddVisibleDeclarationToProtectedType;

   --------------------------------------------------------------------------------

   begin -- AddVisibleDeclaration
      case RawDict.GetSymbolDiscriminant (Region) is
         when PackageSymbol =>
            AddVisibleDeclarationToPackage (Declaration, Region);
         when TypeSymbol =>  -- must be a protected type
            AddVisibleDeclarationToProtectedType (Declaration, Region);
         when others =>
            null; -- should never occur
      end case;
   end AddVisibleDeclaration;

   --------------------------------------------------------------------------------
   --------------------------------------------------------------------------------

   procedure AddLocalDeclaration (Declaration, Region : in Symbol)
   --# global in out Dict;
   --# derives Dict from *,
   --#                   Declaration,
   --#                   Region;
   is

      procedure AddLocalDeclarationToPackage (Declaration, ThePackage : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Declaration,
      --#                   ThePackage;
      is
         Previous : Symbol;
      begin

         Previous := RawDict.GetPackageLastLocalDeclaration (ThePackage);

         if Previous = NullSymbol then
            RawDict.SetPackageFirstLocalDeclaration (ThePackage, Declaration);
         else
            RawDict.SetNextDeclaration (Previous, Declaration);
         end if;

         RawDict.SetPackageLastLocalDeclaration (ThePackage, Declaration);

      end AddLocalDeclarationToPackage;

      --------------------------------------------------------------------------------

      procedure AddLocalDeclarationToSubprogram (Declaration, Subprogram : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Declaration,
      --#                   Subprogram;
      is
         Previous : Symbol;
      begin

         Previous := RawDict.GetSubprogramLastDeclaration (Subprogram);

         if Previous = NullSymbol then
            RawDict.SetSubprogramFirstDeclaration (Subprogram, Declaration);
         else
            RawDict.SetNextDeclaration (Previous, Declaration);
         end if;

         RawDict.SetSubprogramLastDeclaration (Subprogram, Declaration);

      end AddLocalDeclarationToSubprogram;

      --------------------------------------------------------------------------------

      procedure AddLocalDeclarationToProtectedType (Declaration, TheProtectedType : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Declaration,
      --#                   TheProtectedType;
      is
         Previous : Symbol;
      begin

         Previous := RawDict.GetProtectedTypeLastLocalDeclaration (TheProtectedType);

         if Previous = NullSymbol then
            RawDict.SetProtectedTypeFirstLocalDeclaration (TheProtectedType, Declaration);
         else
            RawDict.SetNextDeclaration (Previous, Declaration);
         end if;

         RawDict.SetProtectedTypeLastLocalDeclaration (TheProtectedType, Declaration);

      end AddLocalDeclarationToProtectedType;

      --------------------------------------------------------------------------------

      procedure AddLocalDeclarationToTaskType (Declaration, TheTaskType : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Declaration,
      --#                   TheTaskType;
      is
         Previous : Symbol;
      begin

         Previous := RawDict.GetTaskTypeLastLocalDeclaration (TheTaskType);

         if Previous = NullSymbol then
            RawDict.SetTaskTypeFirstLocalDeclaration (TheTaskType, Declaration);
         else
            RawDict.SetNextDeclaration (Previous, Declaration);
         end if;

         RawDict.SetTaskTypeLastLocalDeclaration (TheTaskType, Declaration);

      end AddLocalDeclarationToTaskType;

      --------------------------------------------------------------------------------

   begin
      case RawDict.GetSymbolDiscriminant (Region) is
         when PackageSymbol =>
            AddLocalDeclarationToPackage (Declaration, Region);
         when TypeSymbol =>
            if RawDict.GetTypeDiscriminant (Region) = ProtectedType then
               AddLocalDeclarationToProtectedType (Declaration, Region);
            elsif RawDict.GetTypeDiscriminant (Region) = TaskType then
               AddLocalDeclarationToTaskType (Declaration, Region);
            else
               null; -- should never occur
            end if;
         when SubprogramSymbol =>
            AddLocalDeclarationToSubprogram (Declaration, Region);
         when others =>
            null; -- should never occur
      end case;
   end AddLocalDeclaration;

   --------------------------------------------------------------------------------

   procedure AddPrivateDeclaration (Declaration, Region : in Symbol)
   --# global in out Dict;
   --# derives Dict from *,
   --#                   Declaration,
   --#                   Region;
   is

      procedure AddPrivateDeclarationToPackage (Declaration, ThePackage : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Declaration,
      --#                   ThePackage;
      is
         Previous : Symbol;
      begin

         Previous := RawDict.GetPackageLastPrivateDeclaration (ThePackage);

         if Previous = NullSymbol then
            RawDict.SetPackageFirstPrivateDeclaration (ThePackage, Declaration);
         else
            RawDict.SetNextDeclaration (Previous, Declaration);
         end if;

         RawDict.SetPackageLastPrivateDeclaration (ThePackage, Declaration);

      end AddPrivateDeclarationToPackage;

      --------------------------------------------------------------------------------

      procedure AddPrivateDeclarationToProtectedType (Declaration, TheProtectedType : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Declaration,
      --#                   TheProtectedType;
      is
         Previous : Symbol;
      begin

         Previous := RawDict.GetProtectedTypeLastPrivateDeclaration (TheProtectedType);

         if Previous = NullSymbol then
            RawDict.SetProtectedTypeFirstPrivateDeclaration (TheProtectedType, Declaration);
         else
            RawDict.SetNextDeclaration (Previous, Declaration);
         end if;

         RawDict.SetProtectedTypeLastPrivateDeclaration (TheProtectedType, Declaration);

      end AddPrivateDeclarationToProtectedType;

      --------------------------------------------------------------------------------

   begin -- AddPrivateDeclaration
      case RawDict.GetSymbolDiscriminant (Region) is
         when PackageSymbol =>
            AddPrivateDeclarationToPackage (Declaration, Region);
         when TypeSymbol =>  -- must be a protected type
            AddPrivateDeclarationToProtectedType (Declaration, Region);
         when others =>
            null; -- should never occur
      end case;
   end AddPrivateDeclaration;


begin --AddDeclaration

   RawDict.CreateDeclaration (Item, Context, Current);
   RawDict.SetDeclarationScope (Current, Scope);

   case Scope.TypeOfScope is
      when Visible =>
         AddVisibleDeclaration (Current, GetRegion (Scope));
      when Local =>
         AddLocalDeclaration (Current, GetRegion (Scope));
      when Privat =>
         AddPrivateDeclaration (Current, GetRegion (Scope));
   end case;

   Declaration := Current;

end AddDeclaration;
