-- $Id: declarations.ads 12696 2009-03-12 13:14:05Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with Cells,
  Dictionary,
  Labels,
  LexTokenManager,
  Pairs,
  SPARK_IO;

use type Dictionary.Symbol;
use type LexTokenManager.LexString;
use type Cells.Cell_Kind;
use type Cells.Cell;
use type Cells.Cell_Rank;

--# inherit AdjustFDL_RWs,
--#         Cells,
--#         CLists,
--#         CommandLineData,
--#         CStacks,
--#         DAG_IO,
--#         Debug,
--#         Dictionary,
--#         ELStrings,
--#         ErrorHandler,
--#         EStrings,
--#         ExaminerConstants,
--#         Labels,
--#         LexTokenManager,
--#         Lists,
--#         Maths,
--#         Pairs,
--#         Pile,
--#         SPARK_IO,
--#         SPSymbols,
--#         Statistics,
--#         SystemErrors;

package Declarations
--# own State;
--# initializes State;
is

   type UsedSymbolIterator is private;
   NullIterator : constant UsedSymbolIterator;

   procedure Initialize (It : out UsedSymbolIterator);
   --# global in State;
   --# derives It from State;

   function CurrentNode (It   : in UsedSymbolIterator) return Cells.Cell;

   function NextNode (Heap : in Cells.Heap_Record;
                      It   : in UsedSymbolIterator) return UsedSymbolIterator;

   function IsNullIterator (It : in UsedSymbolIterator) return Boolean;

   procedure StartProcessing (Heap : in out Cells.Heap_Record);
   --# global in out Statistics.TableUsage;
   --#           out State;
   --# derives Heap,
   --#         State                 from Heap &
   --#         Statistics.TableUsage from *,
   --#                                    Heap;

   procedure Add (Heap   : in out Cells.Heap_Record;
                  Symbol : in     Dictionary.Symbol);
   --# global in     Dictionary.Dict;
   --#        in out State;
   --#        in out Statistics.TableUsage;
   --# derives Heap,
   --#         State,
   --#         Statistics.TableUsage from *,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    State,
   --#                                    Symbol;

   procedure AddAttribute (Heap     : in out Cells.Heap_Record;
                           TickCell : in     Cells.Cell);
   --# global in     Dictionary.Dict;
   --#        in     State;
   --#        in out Statistics.TableUsage;
   --# derives Heap,
   --#         Statistics.TableUsage from *,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    State,
   --#                                    TickCell;

   procedure AddBitwiseOp (Heap     : in out Cells.Heap_Record;
                           OpCell   : in     Cells.Cell);
   --# global in     Dictionary.Dict;
   --#        in out State;
   --#        in out Statistics.TableUsage;
   --# derives Heap,
   --#         State,
   --#         Statistics.TableUsage from *,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    OpCell,
   --#                                    State;

   procedure AddProcedureExport (Heap       : in out Cells.Heap_Record;
                                 ExportCell : in     Cells.Cell);
   --# global in     Dictionary.Dict;
   --#        in out State;
   --#        in out Statistics.TableUsage;
   --# derives Heap,
   --#         State,
   --#         Statistics.TableUsage from *,
   --#                                    Dictionary.Dict,
   --#                                    ExportCell,
   --#                                    Heap,
   --#                                    State;

   procedure AddReturnVar (Heap          : in out Cells.Heap_Record;
                           ReturnVarCell : in     Cells.Cell);
   --# global in     Dictionary.Dict;
   --#        in out State;
   --#        in out Statistics.TableUsage;
   --# derives Heap,
   --#         State,
   --#         Statistics.TableUsage from *,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    ReturnVarCell,
   --#                                    State;

   procedure AddUseOfRootInteger;
   --# global in out State;
   --# derives State from *;


   -- Traverses the DAG denoted by Root and adds all declarations
   -- needed by it.
   procedure FindDagDeclarations (Heap        : in out Cells.Heap_Record;
                                  Root        : in     Cells.Cell);
   --# global in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in out State;
   --#        in out Statistics.TableUsage;
   --# derives Heap,
   --#         State,
   --#         Statistics.TableUsage from *,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    LexTokenManager.StringTable,
   --#                                    Root,
   --#                                    State;

   -- Traverses the DAGs denoted by LabelName and adds all declarations
   -- needed by it.
   procedure FindLabelDeclarations (Heap       : in out Cells.Heap_Record;
                                    LabelName  : in     Labels.Label);
   --# global in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in out State;
   --#        in out Statistics.TableUsage;
   --# derives Heap,
   --#         State,
   --#         Statistics.TableUsage from *,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    LabelName,
   --#                                    LexTokenManager.StringTable,
   --#                                    State;

   -- Traverses the VC DAGs denoted by PredicatePair and adds all declarations
   -- needed by them.
   procedure FindVCFormulaDeclarations (Heap          : in out Cells.Heap_Record;
                                        PredicatePair : in     Pairs.Pair);
   --# global in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in out State;
   --#        in out Statistics.TableUsage;
   --# derives Heap,
   --#         State,
   --#         Statistics.TableUsage from *,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    LexTokenManager.StringTable,
   --#                                    PredicatePair,
   --#                                    State;


   procedure PrintDeclarationTail (File : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.FILE_SYS;
   --# derives SPARK_IO.FILE_SYS from *,
   --#                                File;


   procedure OutputDeclarations (Heap        : in out Cells.Heap_Record;
                                 File        : in     SPARK_IO.File_Type;
                                 RuleFile    : in     SPARK_IO.File_Type;
                                 Scope       : in     Dictionary.Scopes;
                                 WriteRules  : in     Boolean;
                                 EndPosition : in     LexTokenManager.TokenPosition);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     State;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.FILE_SYS         from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        EndPosition,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        File,
   --#                                        Heap,
   --#                                        LexTokenManager.StringTable,
   --#                                        RuleFile,
   --#                                        Scope,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        State,
   --#                                        WriteRules &
   --#         Heap,
   --#         Statistics.TableUsage     from *,
   --#                                        Dictionary.Dict,
   --#                                        Heap,
   --#                                        Scope,
   --#                                        State,
   --#                                        WriteRules;

private
   type UsedSymbolIterator is record
      It : Cells.Cell;
   end record;

   NullIterator : constant UsedSymbolIterator :=
     UsedSymbolIterator'(It => Cells.Null_Cell);

end Declarations;
