-- $Id: declarations-outputdeclarations.adb 12696 2009-03-12 13:14:05Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with SystemErrors;

separate (Declarations)
procedure OutputDeclarations (Heap        : in out Cells.Heap_Record;
                              File        : in     SPARK_IO.File_Type;
                              RuleFile    : in     SPARK_IO.File_Type;
                              Scope       : in     Dictionary.Scopes;
                              WriteRules  : in     Boolean;
                              EndPosition : in     LexTokenManager.TokenPosition)
is
   NeededSymbols : Cells.Cell;

   ---------------------------------------------------------------------

   function IsLocalOwnVariableWithRefinement (Sym   : Dictionary.Symbol;
                                              Scope : Dictionary.Scopes) return Boolean
      --# global in Dictionary.Dict;
   is
      Result : Boolean;
   begin
      if Dictionary.IsOwnVariable (Sym) then
         if Dictionary.OwnVariableHasType (Sym, Scope) then
            -- it has a concrete type so it can't be what we are looking for
            Result := False;
         else
            -- it may be what we are looking for; see if it is local to this package
            Result := Dictionary.GetOwner (Sym) = Dictionary.GetEnclosingPackage (Scope);
         end if;
      else
         Result := False;
      end if;
      return Result;
   end IsLocalOwnVariableWithRefinement;

   ---------------------------------------------------------------------

   procedure GenerateDeclarations (Heap          : in out Cells.Heap_Record;
                                   UsedSymbols   : in     Cells.Cell;
                                   Scope         : in     Dictionary.Scopes;
                                   NeededSymbols :    out Cells.Cell)
   --# global in     AttributeList;
   --#        in     Dictionary.Dict;
   --#        in out Statistics.TableUsage;
   --# derives Heap,
   --#         Statistics.TableUsage from *,
   --#                                    AttributeList,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    Scope,
   --#                                    UsedSymbols &
   --#         NeededSymbols         from AttributeList,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    Scope,
   --#                                    UsedSymbols;
   is separate;

   ---------------------------------------------------------------------

   procedure PrintDeclarations (Heap          : in out Cells.Heap_Record;
                                File          : in     SPARK_IO.File_Type;
                                RuleFile      : in     SPARK_IO.File_Type;
                                NeededSymbols : in     Cells.Cell;
                                Scope         : in     Dictionary.Scopes;
                                WriteRules    : in     Boolean;
                                EndPosition   : in     LexTokenManager.TokenPosition)
   --# global in     AttributeList;
   --#        in     BitwiseOpList;
   --#        in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     ProcedureExportList;
   --#        in     ReturnSymbol;
   --#        in     RootIntegerUsed;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --# derives ErrorHandler.ErrorContext from *,
   --#                                        CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        EndPosition,
   --#                                        File,
   --#                                        Heap,
   --#                                        LexTokenManager.StringTable,
   --#                                        NeededSymbols,
   --#                                        RuleFile,
   --#                                        Scope,
   --#                                        SPARK_IO.FILE_SYS,
   --#                                        WriteRules &
   --#         Heap,
   --#         Statistics.TableUsage     from *,
   --#                                        Dictionary.Dict,
   --#                                        Heap,
   --#                                        NeededSymbols,
   --#                                        Scope,
   --#                                        WriteRules &
   --#         SPARK_IO.FILE_SYS         from *,
   --#                                        AttributeList,
   --#                                        BitwiseOpList,
   --#                                        CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        EndPosition,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        File,
   --#                                        Heap,
   --#                                        LexTokenManager.StringTable,
   --#                                        NeededSymbols,
   --#                                        ProcedureExportList,
   --#                                        ReturnSymbol,
   --#                                        RootIntegerUsed,
   --#                                        RuleFile,
   --#                                        Scope,
   --#                                        WriteRules;
   is separate;

begin -- OutputDeclarations

   if Pile.OrderOK (Heap, UsedSymbols) then
      --Debug.PrintMsg ("UsedSymbols order OK", True);
      null;
   else
      --Debug.PrintMsg ("Dump of UsedSymbols before GenerateDeclarations", True);
      Pile.PrintPile (Heap, UsedSymbols);
      SystemErrors.FatalError (SystemErrors.AssertionFailure,
                               "UsedSymbols before GenerateDeclarations not in order");
   end if;

   GenerateDeclarations (Heap, UsedSymbols, Scope, NeededSymbols);

   if Pile.OrderOK (Heap, NeededSymbols) then
      --Debug.PrintMsg ("NeededSymbols order OK", True);
      null;
   else
      --Debug.PrintMsg ("Dump of NeededSymbols after GenerateDeclarations", True);
      Pile.PrintPile (Heap, NeededSymbols);
      SystemErrors.FatalError (SystemErrors.AssertionFailure,
                               "NeededSymbols after GenerateDeclarations not in order");
   end if;

   PrintDeclarations (Heap, File, RuleFile, NeededSymbols, Scope, WriteRules, EndPosition);
end OutputDeclarations;
