-- $Id: declarations-outputdeclarations-printdeclarations-printruleheader.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Declarations.OutputDeclarations.PrintDeclarations)
procedure PrintRuleHeader (WriteRules : in Boolean;
                           RuleFile   : in SPARK_IO.File_Type)
is
   Ok : Boolean;

   procedure SetUpFamilyName
   --# global in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     Scope;
   --#           out RuleFamilyName;
   --# derives RuleFamilyName from Dictionary.Dict,
   --#                             LexTokenManager.StringTable,
   --#                             Scope;
   is
      MaxNameLen : constant EStrings.Lengths := 12;
   begin
      LexTokenManager.LexStringToString
         (Dictionary.GetSimpleName (Dictionary.GetRegion (Scope)),
          RuleFamilyName);
      if RuleFamilyName.Length > MaxNameLen then
         RuleFamilyName.Length := MaxNameLen;
      end if;
      RuleFamilyName := EStrings.LowerCase (RuleFamilyName);
      EStrings.AppendString (RuleFamilyName, "_rules");
   end SetUpFamilyName;

begin --PrintRuleHeader

   --# accept Flow, 10, Ok, "Expected ineffective assignment to Ok";
   Lists.NewList (LHeap, TypeList, Ok);
   --# end accept;

   SetUpFamilyName;
   RuleCounter := 0;

   if WriteRules then

      SPARK_IO.Put_String (RuleFile, "rule_family ", 0);
      EStrings.PutString (RuleFile, RuleFamilyName);
      SPARK_IO.Put_Line (RuleFile, ":", 0);

      SPARK_IO.Set_Col (RuleFile, 2 * Indent);
      SPARK_IO.Put_Line (RuleFile, "X      requires [X:any] &", 0);

      SPARK_IO.Set_Col (RuleFile, 2 * Indent);
      SPARK_IO.Put_Line (RuleFile, "X <= Y requires [X:ire, Y:ire] &", 0);

      SPARK_IO.Set_Col (RuleFile, 2 * Indent);
      SPARK_IO.Put_Line (RuleFile, "X >= Y requires [X:ire, Y:ire].", 0);
      SPARK_IO.New_Line (RuleFile, 1);

   end if;
   --# accept Flow, 33, Ok, "Expected Ok to be neither referenced nor exported";
end PrintRuleHeader;
