-- $Id: dag_io.ads 12812 2009-03-27 15:30:32Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with Cells,
     Labels,
     Pairs,
     SPARK_IO,
     Dictionary;

use type Cells.Cell_Kind;
use type Dictionary.Symbol;

--# inherit AdjustFDL_RWs,
--#         Cells,
--#         Clists,
--#         CommandLineData,
--#         CStacks,
--#         Dictionary,
--#         ELStrings,
--#         EStrings,
--#         Labels,
--#         LexTokenManager,
--#         Maths,
--#         Pairs,
--#         SPARK_IO,
--#         SPSymbols,
--#         Statistics,
--#         SystemErrors;

package DAG_IO
is

   ----------------------------------------------------------------
   -- The null string literal "" is declared as a special
   -- deferred constant in FDL using this name.  This name
   -- is also used in Declarations to produce the declaration
   -- of this constant, so it is declared here once.
   -- The name is chosen so that it cannot clash with any
   -- legal user-defined identifer.
   ----------------------------------------------------------------
   Null_String_Literal_Name : constant String := "null__string";


   -- When generating VCG and PFS files, we normally wrap
   -- near 72 columns for human-readable output.
   Default_Wrap_Limit : constant Positive := 72;

   -- The maximum value for Wrap_Limit - indicates basically
   -- that no wrapping is required.  This is used to generate
   -- GraphViz DOT format, where line-breaks are not permitted
   -- in a node label.
   No_Wrap : constant Positive := Positive'Last - 3;

   procedure PrintCellContents (Heap         : in     Cells.Heap_Record;
                                OutputFile   : in     SPARK_IO.File_Type;
                                CellName     : in     Cells.Cell;
                                SuppressWrap : in out Boolean;
                                Scope        : in     Dictionary.Scopes;
                                Wrap_Limit   : in     Positive;
                                Escape_DOT   : in     Boolean);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CellName,
   --#                                CommandLineData.Content,
   --#                                Dictionary.Dict,
   --#                                Escape_DOT,
   --#                                Heap,
   --#                                LexTokenManager.StringTable,
   --#                                OutputFile,
   --#                                Scope,
   --#                                SuppressWrap,
   --#                                Wrap_Limit &
   --#         SuppressWrap      from *,
   --#                                CellName,
   --#                                Heap,
   --#                                LexTokenManager.StringTable;

   procedure PrintLabel (Heap       : in out Cells.Heap_Record;
                         OutputFile : in     SPARK_IO.File_Type;
                         LabelName  : in     Labels.Label;
                         Scope      : in     Dictionary.Scopes;
                         Wrap_Limit : in     Positive);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --# derives Heap,
   --#         Statistics.TableUsage from *,
   --#                                    Heap,
   --#                                    LabelName &
   --#         SPARK_IO.File_Sys     from *,
   --#                                    CommandLineData.Content,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    LabelName,
   --#                                    LexTokenManager.StringTable,
   --#                                    OutputFile,
   --#                                    Scope,
   --#                                    Wrap_Limit;

   procedure PrintVCFormula (Heap          : in out Cells.Heap_Record;
                             OutputFile    : in     SPARK_IO.File_Type;
                             PredicatePair : in     Pairs.Pair;
                             Scope         : in     Dictionary.Scopes;
                             Wrap_Limit    : in     Positive);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --# derives Heap,
   --#         Statistics.TableUsage from *,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    PredicatePair &
   --#         SPARK_IO.File_Sys     from *,
   --#                                    CommandLineData.Content,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    LexTokenManager.StringTable,
   --#                                    OutputFile,
   --#                                    PredicatePair,
   --#                                    Scope,
   --#                                    Wrap_Limit;



   ---------------------------------------------------------------------
   -- Partition takes an FDL predicate at Root which is assumed to be
   -- a conjunction (i.e A and B and C and ...) and splits it into
   -- a list of the component terms A, B, C, ...
   --
   -- The initial value of SubExpnList must be the result of a
   -- CLists.CreateList operation
   --
   -- The returned list is denoted by the final value of SubExpnList
   --
   -- Partition is used when printing predicates which need to be
   -- split into conjuncts, such as VC hypotheses, conclusions,
   -- and when producing DOT format so we can line-break after each
   -- conjunct.
   ---------------------------------------------------------------------
   procedure Partition (Root        : in     Cells.Cell;
                        SubExpnList : in     Cells.Cell;
                        Heap        : in out Cells.Heap_Record);
   --# global in out Statistics.TableUsage;
   --# derives Heap,
   --#         Statistics.TableUsage from *,
   --#                                    Heap,
   --#                                    Root,
   --#                                    SubExpnList;

   -- Prints the DAG denoted by Root to OutputFile in FDL
   procedure PrintDag (Heap        : in out Cells.Heap_Record;
                       OutputFile  : in     SPARK_IO.File_Type;
                       Root        : in     Cells.Cell;
                       Scope       : in     Dictionary.Scopes;
                       Wrap_Limit  : in     Positive);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --# derives Heap,
   --#         Statistics.TableUsage from *,
   --#                                    Heap,
   --#                                    Root &
   --#         SPARK_IO.File_Sys     from *,
   --#                                    CommandLineData.Content,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    LexTokenManager.StringTable,
   --#                                    OutputFile,
   --#                                    Root,
   --#                                    Scope,
   --#                                    Wrap_Limit;

   -- Prints the DAG denoted by Root to OutputFile in Dot format for the
   -- GraphViz tool
   procedure Print_DAG_Dot (Heap        : in out Cells.Heap_Record;
                            OutputFile  : in     SPARK_IO.File_Type;
                            Root        : in     Cells.Cell;
                            Scope       : in     Dictionary.Scopes;
                            Wrap_Limit  : in     Positive);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --# derives Heap,
   --#         Statistics.TableUsage from *,
   --#                                    Heap,
   --#                                    Root &
   --#         SPARK_IO.File_Sys     from *,
   --#                                    CommandLineData.Content,
   --#                                    Dictionary.Dict,
   --#                                    Heap,
   --#                                    LexTokenManager.StringTable,
   --#                                    OutputFile,
   --#                                    Root,
   --#                                    Scope,
   --#                                    Wrap_Limit;

end DAG_IO;
