-- $Id: dag-buildannotationexpndag-upprocessattributedesignator.adb 12696 2009-03-12 13:14:05Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (DAG.BuildAnnotationExpnDAG)
procedure UpProcessAttributeDesignator (Node : in STree.SyntaxNode)
is
   ExpnFound,
   BaseFound      : Boolean;
   TempCell,
   PrefixCell,
   AttribCell,
   ExpnCell,
   SecondExpnCell : Cells.Cell;
   LexStr,
   AttribName     : LexTokenManager.LexString;
   PrefixType     : Dictionary.Symbol;
   ExpnNode       : STree.SyntaxNode; --830

   -------------------------------------------------------

   procedure EliminateBase (TOS : in Cells.Cell)
   --# global in     PrefixCell;
   --#        in out VCGHeap;
   --# derives VCGHeap from *,
   --#                      PrefixCell,
   --#                      TOS;
   is
      BaseCell : Cells.Cell;

   begin
      BaseCell := LeftPtr (VCGHeap, TOS);
      if Cells.Get_Kind (VCGHeap, BaseCell) = Cells.Op then
         -- 'BASE exists
         Cells.Dispose_Of_Cell (VCGHeap, RightPtr (VCGHeap, BaseCell));
         Cells.Dispose_Of_Cell (VCGHeap, BaseCell);
         SetLeftArgument (TOS, PrefixCell, VCGHeap);
      end if;
   end EliminateBase;

   -------------------------------------------------------

   procedure ModelSimpleFunctionAttribute (StripToRootType : in Boolean)
   --# global in     AttribCell;
   --#        in     Dictionary.Dict;
   --#        in     ExpnCell;
   --#        in     ExpnStack;
   --#        in     PrefixCell;
   --#        in out VCGHeap;
   --# derives VCGHeap from *,
   --#                      AttribCell,
   --#                      Dictionary.Dict,
   --#                      ExpnCell,
   --#                      ExpnStack,
   --#                      PrefixCell,
   --#                      StripToRootType;
   is
   begin
      EliminateBase (CStacks.Top (VCGHeap, ExpnStack));

      -- Most attributes are modelled in FDL by reference to the
      -- underlying root type.  Most notably, 'Valid is always
      -- in terms of the indicated sub-type (see LRM 13.9.1(2)) so we need
      -- the option here to use the Root Type or not.
      if StripToRootType then
         Cells.Set_Symbol_Value (VCGHeap, PrefixCell,
                               Dictionary.GetRootType (Cells.Get_Symbol_Value (VCGHeap,
                                                                       PrefixCell)));
      end if;

      Cells.Set_Kind (VCGHeap, AttribCell, Cells.Attrib_Function);
      SetRightArgument (AttribCell, ExpnCell, VCGHeap);
   end ModelSimpleFunctionAttribute;

   -------------------------------------------------------

   procedure ModelMinMax
   --# global in     AttribCell;
   --#        in     Dictionary.Dict;
   --#        in     ExpnCell;
   --#        in     ExpnStack;
   --#        in     PrefixCell;
   --#        in     SecondExpnCell;
   --#        in out Statistics.TableUsage;
   --#        in out VCGHeap;
   --# derives Statistics.TableUsage from *,
   --#                                    VCGHeap &
   --#         VCGHeap               from *,
   --#                                    AttribCell,
   --#                                    Dictionary.Dict,
   --#                                    ExpnCell,
   --#                                    ExpnStack,
   --#                                    PrefixCell,
   --#                                    SecondExpnCell;
   is
      CommaCell : Cells.Cell;
   begin
      CreateOpCell (CommaCell, VCGHeap, SPSymbols.comma);
      EliminateBase (CStacks.Top (VCGHeap, ExpnStack));
      Cells.Set_Symbol_Value (VCGHeap, PrefixCell,
                            Dictionary.GetRootType (Cells.Get_Symbol_Value (VCGHeap,
                                                                    PrefixCell)));
      Cells.Set_Kind (VCGHeap, AttribCell, Cells.Attrib_Function);
      SetLeftArgument (CommaCell, ExpnCell, VCGHeap);
      SetRightArgument (CommaCell, SecondExpnCell, VCGHeap);
      SetRightArgument (AttribCell, CommaCell, VCGHeap);
   end ModelMinMax;

   -------------------------------------------------------

   procedure ModelLengthAttribute
   --# global in     Dictionary.Dict;
   --#        in out ExpnStack;
   --#        in out LexTokenManager.StringTable;
   --#        in out Statistics.TableUsage;
   --#        in out VCGHeap;
   --# derives ExpnStack,
   --#         Statistics.TableUsage,
   --#         VCGHeap                     from *,
   --#                                          Dictionary.Dict,
   --#                                          ExpnStack,
   --#                                          LexTokenManager.StringTable,
   --#                                          VCGHeap &
   --#         LexTokenManager.StringTable from *;
   is
      OneCell,
      HighEndCell,
      LowEndCell  : Cells.Cell;
      TypeSym     : Dictionary.Symbol;
      LexStr      : LexTokenManager.LexString;

      ----------------------------------------------

      procedure InsertPos
      --# global in     TypeSym;
      --#        in out HighEndCell;
      --#        in out LowEndCell;
      --#        in out Statistics.TableUsage;
      --#        in out VCGHeap;
      --# derives HighEndCell           from TypeSym,
      --#                                    VCGHeap &
      --#         LowEndCell            from HighEndCell,
      --#                                    TypeSym,
      --#                                    VCGHeap &
      --#         Statistics.TableUsage from *,
      --#                                    HighEndCell,
      --#                                    TypeSym,
      --#                                    VCGHeap &
      --#         VCGHeap               from *,
      --#                                    HighEndCell,
      --#                                    LowEndCell,
      --#                                    TypeSym;
      is
         PosCell : Cells.Cell;

      begin
         CreateAttribFunctionCell (LexTokenManager.PosToken, TypeSym, VCGHeap, PosCell);
         SetRightArgument (RightPtr (VCGHeap, PosCell), HighEndCell, VCGHeap);
         HighEndCell := PosCell;
         CreateAttribFunctionCell (LexTokenManager.PosToken, TypeSym, VCGHeap, PosCell);
         SetRightArgument (RightPtr (VCGHeap, PosCell), LowEndCell, VCGHeap);
         LowEndCell := PosCell;
      end InsertPos;

      ----------------------------------------------

   begin --ModelLengthAttribute
      CStacks.PopOff (VCGHeap, ExpnStack, HighEndCell);
      Structures.CopyStructure (VCGHeap, HighEndCell, LowEndCell);
      Cells.Set_Lex_Str (VCGHeap, RightPtr (VCGHeap, HighEndCell), LexTokenManager.LastToken);
      Cells.Set_Lex_Str (VCGHeap, RightPtr (VCGHeap, LowEndCell), LexTokenManager.FirstToken);
      TypeSym := Cells.Get_Symbol_Value (VCGHeap, LeftPtr (VCGHeap, HighEndCell));
      if Dictionary.IsTypeMark (TypeSym) and then
         Dictionary.TypeIsEnumeration (TypeSym)
      then
         InsertPos;
      end if;
      CStacks.Push (VCGHeap, HighEndCell, ExpnStack);
      CStacks.Push (VCGHeap, LowEndCell, ExpnStack);
      PushOperator (Binary, SPSymbols.minus, VCGHeap, ExpnStack);
      LexTokenManager.InsertNat (1, LexStr);
      CreateManifestConstCell (OneCell, VCGHeap, LexStr);
      CStacks.Push (VCGHeap, OneCell, ExpnStack);
      PushOperator (Binary, SPSymbols.plus, VCGHeap, ExpnStack);
   end ModelLengthAttribute;

   -------------------------------------------------------

   procedure ModelTailFunctionAttribute
   --# global in     AttribCell;
   --#        in     ExpnCell;
   --#        in out VCGHeap;
   --# derives VCGHeap from *,
   --#                      AttribCell,
   --#                      ExpnCell;
   is
   begin -- ModelTailFunctionAttribute
      Cells.Set_Kind (VCGHeap, AttribCell, Cells.Attrib_Function);
      SetRightArgument (AttribCell, ExpnCell, VCGHeap);
   end ModelTailFunctionAttribute;

   -------------------------------------------------------

   procedure ModelAppendFunctionAttribute
   --# global in     AttribCell;
   --#        in     ExpnCell;
   --#        in     SecondExpnCell;
   --#        in out Statistics.TableUsage;
   --#        in out VCGHeap;
   --# derives Statistics.TableUsage from *,
   --#                                    VCGHeap &
   --#         VCGHeap               from *,
   --#                                    AttribCell,
   --#                                    ExpnCell,
   --#                                    SecondExpnCell;
   is
      CommaCell : Cells.Cell;
   begin  -- ModelAppendFunctionAttribute
      CreateOpCell (CommaCell, VCGHeap, SPSymbols.comma);
      Cells.Set_Kind (VCGHeap, AttribCell, Cells.Attrib_Function);
      SetLeftArgument (CommaCell, ExpnCell, VCGHeap);
      SetRightArgument (CommaCell, SecondExpnCell, VCGHeap);
      SetRightArgument (AttribCell, CommaCell, VCGHeap);
   end ModelAppendFunctionAttribute;

   -------------------------------------------------------

begin --UpProcessAttributeDesignator
      --  If there are any expression associated with the attribute they will be TOS
      --  Below it (or TOS if there is no expression) is a DAG representing the attribute

   -- move to where first expression would be if there is one
   ExpnNode := STree.Child_Node
      (STree.LastSiblingOf
       (STree.Child_Node (Node)));

   --# assert True;
   -- check for second expression
   if STree.Next_Sibling (ExpnNode) /= STree.NullNode then
      -- There is a 2nd expression associated with attribute
      CStacks.PopOff (VCGHeap, ExpnStack, SecondExpnCell);
   else
      SecondExpnCell := Cells.Null_Cell;
   end if;

   --# assert True;
   -- then check for first expression
   if ExpnNode /= STree.NullNode then
      -- There is a 2nd expression associated with attribute
      CStacks.PopOff (VCGHeap, ExpnStack, ExpnCell);
      ExpnFound := True;
   else
      ExpnCell := Cells.Null_Cell;
      ExpnFound := False;
   end if;

   --# assert True;
   PrefixCell := LeftPtr (VCGHeap, CStacks.Top (VCGHeap, ExpnStack));
   if Cells.Get_Kind (VCGHeap, PrefixCell) = Cells.Op then  --must be a 'BASE
      PrefixCell := LeftPtr (VCGHeap, PrefixCell);
      BaseFound := True;
   else
      BaseFound := False;
   end if;

   -- If no expression forms part of the attribute we
   -- now need to make a copy of the prefix for possible use in modelling 'valid.
   -- This is because fdl model of valid takes an argument which is created from the
   -- prefix to the attribute.  By the time we know we are modelling 'valid this prefix
   -- subtree may have been patched with type information extracted from the syntax tree
   --# assert True;
   if not ExpnFound then
      Structures.CopyStructure (VCGHeap,
                                PrefixCell,
                                 -- to get
                                ExpnCell);
   end if;

   AttribCell := RightPtr (VCGHeap, CStacks.Top (VCGHeap, ExpnStack));
   AttribName := Cells.Get_Lex_Str (VCGHeap, AttribCell);

   -- Recover type planted in syntax tree by wellformation checker.
   -- For all cases except attributes of unconstrained objects, this will be type mark.
   -- For attributes of constrained array objects the wffs will haev resolved all such
   -- things as dimesnion number arguments and will have planted the appropriate type.
   -- For unconstraiend objects only, the wffs will plant a symbol of a special kind
   -- (ParameterConstraintSymbol) associated with the object.  This special symbol kind
   -- behaves for all practical purposes like a type except that we typically don't
   -- know its bounds.

   PrefixType := STree.NodeSymbol (Node);
   Cells.Set_Kind (VCGHeap, PrefixCell, Cells.Fixed_Var);

   -- Note that we only do this if the attribute is not a proof attribute (e.g. 'Tail or 'Append)
   -- because if it is then we want the prefix to be the object not its type.  In this case
   -- we just want to convert the prefix to a fixed var cell

   --# assert True;
   if AttribName /= LexTokenManager.TailToken and then
      AttribName /= LexTokenManager.AppendToken then
      -- transform prefix cell to be cell just containing the prefix type
      Cells.Set_Symbol_Value (VCGHeap, PrefixCell, PrefixType);
   end if;

   -- If prefix is unconstrained object then make cell an UnconstrainedAttributePrefix to allow special
   -- formal-to-actual substitution in procedure and function call pre con and proc call post con checks
   if Dictionary.IsSubprogramParameterConstraint (PrefixType) then
      Cells.Set_Kind (VCGHeap, PrefixCell, Cells.Unconstrained_Attribute_Prefix);
   end if;

   -- make leaf
   SetLeftArgument (PrefixCell, Cells.Null_Cell, VCGHeap);
   SetRightArgument (PrefixCell, Cells.Null_Cell, VCGHeap);
   SetAuxPtr (PrefixCell, Cells.Null_Cell, VCGHeap);

   --# assert True;
   if AttribName = LexTokenManager.PosToken or
      AttribName = LexTokenManager.ValToken
   then
      if Dictionary.TypeIsEnumeration (PrefixType) and then
        not Dictionary.TypeIsCharacter (PrefixType) then

         -- Enumeration type but NOT character - model as an FDL
         -- function
         ModelSimpleFunctionAttribute (StripToRootType => True);
      else
         -- must be discrete numeric type or character so simply discard attribute,
         -- since for all integer (signed or modular) and Character types X (or subtypes
         -- thereof...), X'Pos (Y) = X'Val (Y) = Y
         EliminateBase (CStacks.Top (VCGHeap, ExpnStack));
         CStacks.PopOff (VCGHeap, ExpnStack, TempCell);
         Cells.Dispose_Of_Cell (VCGHeap, LeftPtr (VCGHeap, TempCell));
         Cells.Dispose_Of_Cell (VCGHeap, RightPtr (VCGHeap, TempCell));
         Cells.Dispose_Of_Cell (VCGHeap, TempCell);
         CStacks.Push (VCGHeap, ExpnCell, ExpnStack);
      end if;
   elsif AttribName = LexTokenManager.PredToken or
      AttribName = LexTokenManager.SuccToken
   then
      EliminateBase (CStacks.Top (VCGHeap, ExpnStack));
      CStacks.PopOff (VCGHeap, ExpnStack, TempCell);
      Cells.Dispose_Of_Cell (VCGHeap, LeftPtr (VCGHeap, TempCell));
      Cells.Dispose_Of_Cell (VCGHeap, RightPtr (VCGHeap, TempCell));
      Cells.Dispose_Of_Cell (VCGHeap, TempCell);
      CStacks.Push (VCGHeap, ExpnCell, ExpnStack);

      if Dictionary.TypeIsEnumeration (PrefixType) then
         if AttribName = LexTokenManager.SuccToken then
            PushFunction (Cells.Succ_Function, VCGHeap, ExpnStack);
         else
            PushFunction (Cells.Pred_Function, VCGHeap, ExpnStack);
         end if;
      else -- must be discrete numeric type so use + or - instead
         LexTokenManager.InsertNat (1, LexStr);
         CreateManifestConstCell (TempCell, VCGHeap, LexStr);
         CStacks.Push (VCGHeap, TempCell, ExpnStack);
         if  AttribName = LexTokenManager.SuccToken then
            PushOperator (Binary, SPSymbols.plus, VCGHeap, ExpnStack);
         else
            PushOperator (Binary, SPSymbols.minus, VCGHeap, ExpnStack);
         end if;
         ModularizeIfNeeded (PrefixType, VCGHeap, ExpnStack);
      end if;

   elsif AttribName = LexTokenManager.FirstToken or
      AttribName = LexTokenManager.LastToken
   then
      if BaseFound and then
         Dictionary.TypeIsEnumeration (PrefixType)
      then
         Cells.Set_Symbol_Value (VCGHeap,
                               PrefixCell,
                               Dictionary.GetRootType (PrefixType));
         EliminateBase (CStacks.Top (VCGHeap, ExpnStack));
      end if;

   elsif AttribName = LexTokenManager.RangeToken then
      TransformRangeConstraint (VCGHeap, ExpnStack);

   elsif AttribName = LexTokenManager.LengthToken then
      ModelLengthAttribute;

   elsif AttribName = LexTokenManager.MaxToken   or else  --830
         AttribName = LexTokenManager.MinToken then
      ModelMinMax;

   elsif AttribName = LexTokenManager.ValidToken then
      -- using the ExpnCell which is a copy of the prefix
      -- to the attribute made earlier.
      --
      -- Data validity is defined in terms of the indicated sub-type
      -- (LRM 13.9.1(2)), so we don't strip to the root type in this case
      ModelSimpleFunctionAttribute (StripToRootType => False);

   elsif AttribName = LexTokenManager.FloorToken or
     AttribName = LexTokenManager.CeilingToken then
      ModelSimpleFunctionAttribute (StripToRootType => True);

   elsif AttribName = LexTokenManager.TailToken then
      ModelTailFunctionAttribute;

   elsif AttribName = LexTokenManager.AppendToken then
      ModelAppendFunctionAttribute;

   else -- it's a non-function, non-substitutable attribute
      if Cells.Get_Kind (VCGHeap, PrefixCell) = Cells.Reference then
         Cells.Set_Kind (VCGHeap, PrefixCell, Cells.Fixed_Var);
      end if;
   end if;

end UpProcessAttributeDesignator;
