-- $Id: contextmanager.ads 13056 2009-04-20 17:01:20Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with ErrorHandler,
     SparkLex,
     STree,
     ExaminerConstants,
     SPARK_IO,
     EStrings,
     CommandLineData,
     LexTokenLists;

--# inherit CommandLineData,
--#         ErrorHandler,
--#         EStrings,
--#         ExaminerConstants,
--#         LexTokenLists,
--#         LexTokenManager,
--#         SparkLex,
--#         SPARK_IO,
--#         STree,
--#         SystemErrors;

package ContextManager
--# own FileHeap  : FileHeaps;
--#     UnitHeap  : UnitHeaps;
--#     UnitStack : UnitStacks;
--# initializes FileHeap,
--#             UnitHeap,
--#             UnitStack;
is
   type UnitTypes is (MainProgram,
                      PackageSpecification, -- use this one when we have a package body and know we need spec
                      PackageBody,
                      SubUnit,
                      InterUnitPragma,
                      GenericDeclaration, -- use this one when we have a generic body and know we need spec
                      GenericPackageInstantiation,
                      GenericSubprogramBody,
                      InvalidUnit,
                        -- this one is for inherited items where we don't know which it is
                      PackageOrGenericDeclaration);

   type UnitTypeSets is array (UnitTypes) of Boolean;

   -- set of inheritable things (was previously only packages)
   InheritableItem : constant UnitTypeSets :=
     UnitTypeSets'(PackageSpecification => True,
                   GenericDeclaration => True,
                   others => False);

   PackageSpecificationSet : constant UnitTypeSets :=
     UnitTypeSets'(PackageSpecification => True,
                   others => False);

   -- this is for generic subprogram declarations, where we know that is what we want because we found a generic body
   GenericDeclarationSet : constant UnitTypeSets :=
     UnitTypeSets'(GenericDeclaration => True,
                   others => False);

   BodySet : constant UnitTypeSets :=
      UnitTypeSets'(MainProgram | PackageBody => True, others => False);

   SubUnitSet : constant UnitTypeSets :=
      UnitTypeSets'(SubUnit | PackageBody => True, others => False);

   type UnitDescriptors is private;
   type FileDescriptors is private;

   NullUnit : constant UnitDescriptors;
   NullFile : constant FileDescriptors;

   type UnitStatus is (NoUnitEntry, UnitCreated, UnitParsed,
                       UnitDeferred,
                       UnitAnalysed,
                       NoIndexFile,
                       NotInIndexFile,
                       CannotOpenFile,
                       UnableToLocate);

   subtype UnitNotFound is UnitStatus range NoIndexFile .. UnableToLocate;

   type FileStatus is (NoFileEntry, FileCreated, FileOpen,
                       FileEnd, UnableToOpen);

   function CurrentUnit  return UnitDescriptors;
   --# global in UnitStack;
   function GetUnitStatus (Descriptor : UnitDescriptors) return UnitStatus;
   --# global in UnitHeap;
   procedure CreateUnitDescriptor (Descriptor : out UnitDescriptors);
   --# global in out UnitHeap;
   --# derives Descriptor,
   --#         UnitHeap   from UnitHeap;

   procedure SetFileDescriptor (UnitDescriptor : in UnitDescriptors;
                                FileDescriptor : in FileDescriptors);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       FileDescriptor,
   --#                       UnitDescriptor;

   procedure GetFileDescriptor (UnitDescriptor : in UnitDescriptors;
                                FileDescriptor : out FileDescriptors);
   --# global in UnitHeap;
   --# derives FileDescriptor from UnitDescriptor,
   --#                             UnitHeap;

   procedure SetUnitStatus (Descriptor : in UnitDescriptors;
                            Status     : in UnitStatus);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       Descriptor,
   --#                       Status;

   -- 051 -- Added following four subprograms
   procedure IncUnitCount (Descriptor : in FileDescriptors);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor;

   procedure GetUnitCount (Descriptor : in     FileDescriptors;
                           Count      :    out Natural);
   --# global in FileHeap;
   --# derives Count from Descriptor,
   --#                    FileHeap;

   function GetUnitNumber (Descriptor : UnitDescriptors) return Natural;
   --# global in UnitHeap;
   procedure SetUnitNumber (Descriptor : in UnitDescriptors;
                            Count      : in Natural);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       Count,
   --#                       Descriptor;

   function GetFileStatus (Descriptor : FileDescriptors) return FileStatus;
   --# global in FileHeap;
   procedure SetRedType (Descriptor : in UnitDescriptors;
                         RedType    : in CommandLineData.RedTypes);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       Descriptor,
   --#                       RedType;

   procedure GetRedType (Descriptor : in     UnitDescriptors;
                         RedType    :    out CommandLineData.RedTypes);
   --# global in UnitHeap;
   --# derives RedType from Descriptor,
   --#                      UnitHeap;

   procedure GetUnitByName (UnitName    : in     LexTokenLists.Lists;
                            UnitTypeSet : in     UnitTypeSets;
                            Descriptor  :    out UnitDescriptors);
   --# global in UnitHeap;
   --# derives Descriptor from UnitHeap,
   --#                         UnitName,
   --#                         UnitTypeSet;

   procedure SetUnitName (Descriptor : in UnitDescriptors;
                          UnitName   : in LexTokenLists.Lists;
                          UnitType   : in UnitTypes);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       Descriptor,
   --#                       UnitName,
   --#                       UnitType;

   procedure GetUnitName (Descriptor : in     UnitDescriptors;
                          UnitName   :    out LexTokenLists.Lists;
                          UnitType   :    out UnitTypes);
   --# global in UnitHeap;
   --# derives UnitName,
   --#         UnitType from Descriptor,
   --#                       UnitHeap;

   procedure SetParseTree (Descriptor : in UnitDescriptors;
                           ParseTree  : in STree.SyntaxNode);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       Descriptor,
   --#                       ParseTree;

   procedure GetParseTree (Descriptor : in     UnitDescriptors;
                           ParseTree  :    out STree.SyntaxNode);
   --# global in UnitHeap;
   --# derives ParseTree from Descriptor,
   --#                        UnitHeap;

   procedure MarkUnitInCycle (Descriptor : in UnitDescriptors);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       Descriptor;

   function UnitInCycle (Descriptor : UnitDescriptors) return Boolean;
   --# global in UnitHeap;
   function FirstUnitDescriptor return UnitDescriptors;
   --# global in UnitHeap;
   function NextUnitDescriptor (Descriptor : UnitDescriptors)
                               return UnitDescriptors;
   --# global in UnitHeap;
   procedure PushUnit (Descriptor : in UnitDescriptors);
   --# global in out UnitStack;
   --# derives UnitStack from *,
   --#                        Descriptor;

   procedure PopUnit (Descriptor : out UnitDescriptors);
   --# global in out UnitStack;
   --# derives Descriptor,
   --#         UnitStack  from UnitStack;

   procedure CreateFileDescriptor (Descriptor : out FileDescriptors);
   --# global in out FileHeap;
   --# derives Descriptor,
   --#         FileHeap   from FileHeap;

   procedure SetSourceFileName (Descriptor     : in FileDescriptors;
                                SourceFileName : in EStrings.T);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor,
   --#                       SourceFileName;

   procedure GetSourceFileName (Descriptor     : in     FileDescriptors;
                                SourceFileName :    out EStrings.T);
   --# global in FileHeap;
   --# derives SourceFileName from Descriptor,
   --#                             FileHeap;

   procedure SetSourceFile (Descriptor : in FileDescriptors;
                            SourceFile : in SPARK_IO.File_Type);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor,
   --#                       SourceFile;

   procedure GetSourceFile (Descriptor : in     FileDescriptors;
                            SourceFile :    out SPARK_IO.File_Type);
   --# global in FileHeap;
   --# derives SourceFile from Descriptor,
   --#                         FileHeap;

   function ListingReqt (Descriptor : FileDescriptors) return Boolean;
   --# global in FileHeap;
   function FirstFileDescriptor return FileDescriptors;
   --# global in FileHeap;
   function NextFileDescriptor (Descriptor : FileDescriptors)
      return FileDescriptors;
   --# global in FileHeap;
   procedure GetFileByName (FileName    : in     EStrings.T;
                            Descriptor  :    out FileDescriptors);
   --# global in FileHeap;
   --# derives Descriptor from FileHeap,
   --#                         FileName;

   procedure SetFileStatus (Descriptor  : in FileDescriptors;
                            Status      : in FileStatus);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor,
   --#                       Status;

   procedure SetListingReq (Descriptor : in FileDescriptors;
                            Req        : in Boolean);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor,
   --#                       Req;

   procedure SetLineContext (Descriptor  : in FileDescriptors;
                             FileContext : in SparkLex.LineContext);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor,
   --#                       FileContext;

   procedure GetLineContext (Descriptor  : in     FileDescriptors;
                             FileContext : out SparkLex.LineContext);
   --# global in FileHeap;
   --# derives FileContext from Descriptor,
   --#                          FileHeap;

   procedure SetErrorContext (Descriptor  : in FileDescriptors;
                              Context     : in ErrorHandler.ErrorContexts);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Context,
   --#                       Descriptor;

   procedure GetErrorContext (Descriptor  : in     FileDescriptors;
                              Context     :    out ErrorHandler.ErrorContexts);
   --# global in FileHeap;
   --# derives Context from Descriptor,
   --#                      FileHeap;

   procedure SetListingFileName (Descriptor      : in FileDescriptors;
                                 ListingFileName : in EStrings.T);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor,
   --#                       ListingFileName;

   procedure GetListingFileName (Descriptor      : in  FileDescriptors;
                                 ListingFileName : out EStrings.T);
   --# global in FileHeap;
   --# derives ListingFileName from Descriptor,
   --#                              FileHeap;

   procedure SetErrorsReported (Descriptor : in FileDescriptors);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor;

   function ErrorsReported (Descriptor : FileDescriptors) return Boolean;
   --# global in FileHeap;
private
   type UnitDescriptors is range 0 .. ExaminerConstants.ContextManagerMaxUnits;
   --# assert UnitDescriptors'Base is Short_Integer; -- for GNAT

   type FileDescriptors is range 0 .. ExaminerConstants.ContextManagerMaxFiles;
   --# assert FileDescriptors'Base is Short_Integer; -- for GNAT

   NullUnit : constant UnitDescriptors := 0;
   NullFile : constant FileDescriptors := 0;
end ContextManager;
