-- $Id: configfile.ads 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with SPARK_IO;

use type SPARK_IO.File_Status;

--# inherit CommandLineData,
--#         Dictionary,
--#         ErrorHandler,
--#         Error_IO,
--#         Error_Types,
--#         EStrings,
--#         ExaminerConstants,
--#         FileSystem,
--#         LexTokenLists,
--#         LexTokenManager,
--#         LextokenStacks,
--#         Maths,
--#         ScreenEcho,
--#         SparkLex,
--#         SPARK_IO,
--#         SPExpectedSymbols,
--#         SPSymbols,
--#         Statistics,
--#         SystemErrors,
--#         XMLReport;

package ConfigFile
--# own State;
is

   procedure ReadConfigFile (OpenedOK : out Boolean;
                             NoErrors : out Boolean);
   --# global in     CommandLineData.Content;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.StringTable;
   --#        in out SparkLex.CurrLine;
   --#        in out SPARK_IO.File_Sys;
   --#           out State;
   --# derives Dictionary.Dict,
   --#         ErrorHandler.ErrorContext,
   --#         LexTokenManager.StringTable,
   --#         NoErrors,
   --#         SPARK_IO.File_Sys,
   --#         State                       from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          LexTokenManager.StringTable,
   --#                                          SPARK_IO.File_Sys &
   --#         OpenedOK                    from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          SPARK_IO.File_Sys &
   --#         SparkLex.CurrLine           from *,
   --#                                          CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          LexTokenManager.StringTable,
   --#                                          SPARK_IO.File_Sys;

   procedure OutputConfigFile (ToFile : in SPARK_IO.File_Type);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.StringTable;
   --#        in     State;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.File_Sys;
   --#        in out XMLReport.State;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.File_Sys,
   --#         XMLReport.State           from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.StringTable,
   --#                                        SPARK_IO.File_Sys,
   --#                                        State,
   --#                                        ToFile,
   --#                                        XMLReport.State;

end ConfigFile;
